% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX.mxModel_helper.R
\name{getMIX.mxModel}
\alias{getMIX.mxModel}
\title{Construct An Object of mxModel for Longitudinal Mixture Models To Be Evaluated}
\usage{
getMIX.mxModel(
  dat,
  nClass,
  sub_Model,
  cluster_TIC,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  y_model,
  m_var,
  x_var,
  x_type,
  TVC,
  decompose,
  growth_TIC,
  starts,
  res_cor
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions for each longitudinal process, and time-invariant covariates (TICs) if any. It takes the value
passed from \code{getMIX()}.}

\item{nClass}{An integer specifying the number of latent classes for the mixture model. It takes the value passed from \code{getMIX()}.}

\item{sub_Model}{A string that specifies the sub-model for latent classes. Supported sub-models include \code{"LGCM"} (for latent
growth curve models), \code{"LCSM"} (for latent change score models), \code{"TVC"} (for latent growth curve models or latent change
score models with a time-varying covariate), \code{"MGM"} (for multivariate latent growth curve models or latent change score models),
and \code{"MED"} (for longitudinal mediation models). It takes the value passed from \code{getMIX()}.}

\item{cluster_TIC}{A string or character vector representing the column name(s) for time-invariant covariate(s) indicating cluster
formations. It takes the value passed from \code{getMIX()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable for each study wave. This applies when
\code{sub_Model} is \code{"LGCM"}, \code{"LCSM"} or \code{"TVC"}. For \code{sub_Model} being \code{"MGM"} or \code{"MED"}, \code{t_var} should
be a string vector where each element corresponds to the time variable prefix for each respective longitudinal process. It takes the value
passed from \code{getMIX()}.}

\item{y_var}{A string defining the prefix of the column names corresponding to the outcome variable for each study wave. This is applicable
when \code{sub_Model} is not \code{"MGM"}. For \code{sub_Model} being \code{"MGM"}, \code{y_var} should be a string vector where each element
corresponds to the prefix of the column names for each outcome variable across the study waves. It takes the value passed from \code{getMIX()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model = "LGCM"} include:
\code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported options for
\code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}),
\code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getMIX()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the value passed
from \code{getMIX()}.}

\item{records}{A numeric vector denoting the indices of the observed study waves. This applies when \code{sub_Model} is \code{"LGCM"},
\code{"LCSM"} or \code{"TVC"}. For \code{sub_Model} being \code{"MGM"} or \code{"MED"}, \code{records} should be a list of numeric vectors,
where each vector provides the indices of the observed study waves for each longitudinal process. It takes the value passed from \code{getMIX()}.}

\item{y_model}{A string that specifies how to fit longitudinal outcomes. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getMIX()}.}

\item{m_var}{A string that specifies the prefix of the column names corresponding to the mediator variable at each study wave.
It takes the value passed from \code{getMIX()}.}

\item{x_var}{A string specifying the baseline predictor if \code{x_type = "baseline"}, or the prefix of the column names
corresponding to the predictor variable at each study wave if \code{x_type = "longitudinal"}. It takes the value passed from \code{getMIX()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMIX()}.}

\item{TVC}{A string that specifies the prefix of the column names corresponding to the time-varying covariate at each time
point. It takes the value passed from \code{getMIX()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the value passed
from \code{getMIX()}.}

\item{growth_TIC}{A string or character vector of column names of time-invariant covariate(s) accounting for the variability
of growth factors if any. It takes the value passed from \code{getMIX()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMIX()} or derived by the
helper function \code{getMIX.initial()}.}

\item{res_cor}{A list where each element is a (vector of) numeric initial value(s) for residual correlation in each class. It
needs to be specified if the sub_Model is \code{"TVC"} (when \code{decompose != 0}), \code{"MGM"}, or \code{"MED"}. It takes the
value passed from \code{getMIX()}.}
}
\value{
A pre-optimized mxModel for a longitudinal mixture model.
}
\description{
This function builds up an object of mxModel for a mixture model with user-specified number of latent classes, class-
specific models and functional form (including whether intrinsically nonlinear).
}
\keyword{internal}
