% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX_MULTI.addpara_helper.R
\name{getMIX_MULTI.addpara}
\alias{getMIX_MULTI.addpara}
\title{Get Additional Parameters Related to Interval-specific Slopes, Interval-specific Changes and Values of Change-from-
baseline for Mixture Model with Multivariate Latent Change Score Models as Submodels}
\usage{
getMIX_MULTI.addpara(
  dat,
  nClass,
  t_var,
  records,
  y_var,
  curveFun,
  intrinsic = NULL,
  starts
)
}
\arguments{
\item{dat}{Data frame. Contains the observed variables, including repeated measurements and occasions, and covariates
if any. It takes the value passed from `getMIX()`.}

\item{nClass}{Numeric. Indicates the number of latent classes. It takes the value passed from `getMIX()`.}

\item{t_var}{String. Prefix of the column names corresponding to the time variable at each time point. It takes the value
passed from `getMIX()`.}

\item{records}{Numeric vector. Indices of the observed time points. It takes the value passed from `getMIX()`.}

\item{y_var}{String. Prefix of the column names corresponding to the outcome variable at each time point. It takes the
value passed from `getMIX()`.}

\item{curveFun}{String. The functional form of the growth curve. Supported options include: "linear" (or "LIN"),
"quadratic" (or "QUAD"), "negative exponential" (or "EXP"), "Jenss-Bayley" (or "JB"), "bilinear spline" (or "BLS"),
and "nonparametric" (or "NonP"). It takes the value passed from `getMIX()`.}

\item{intrinsic}{Logical. Whether an intrinsically nonlinear longitudinal model is built up. It takes the value passed
from `getMIX()`.}

\item{starts}{A list of initial values for free parameters, either takes the value passed from `getMIX()` or derived by
the helper function `getMIX.initial()`.}
}
\value{
A list containing the specification of the means and variances of interval-specific slopes, interval-specific
changes, and values of change-from-baseline for a mixture model with multivariate latent change score models as submodels.
}
\description{
This function derives additional parameters for mixture model with multivariate latent change score models as submodels.
It specifies the means and variances of interval-specific slopes, interval-specific changes, and values of change-from-
baseline.
}
\keyword{internal}
