% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{glmnet_wrapper}
\alias{glmnet_wrapper}
\title{Wrapper for fitting a lasso using package \code{glmnet}.}
\usage{
glmnet_wrapper(train, test, alpha = 1, nfolds = 5, nlambda = 100,
  use_min = TRUE, loss = "deviance")
}
\arguments{
\item{train}{A list with named objects \code{Y} and \code{X} (see description).}

\item{test}{A list with named objects \code{Y} and \code{X} (see description).}

\item{alpha}{See \link[glmnet]{glmnet} for further description.}

\item{nfolds}{See \link[glmnet]{glmnet} for further description.}

\item{nlambda}{See \link[glmnet]{glmnet} for further description.}

\item{use_min}{See \link[glmnet]{glmnet} for further description.}

\item{loss}{See \link[glmnet]{glmnet} for further description.}

\item{...}{Other options (passed to \code{SuperLearner})}
}
\value{
A list with named objects (see description).
}
\description{
Compatible learner wrappers for this package should have a specific format.
Namely they should take as input a list called \code{train} that contains
named objects \code{$Y} and \code{$X}, that contain, respectively, the outcomes
and predictors in a particular training fold. Other options may be passed in
to the function as well. The function must output a list with the following
named objects: \code{test_pred} = predictions of \code{test$Y} based on the learner
fit using \code{train$X}; \code{train_pred} = prediction of \code{train$Y} based 
on the learner fit using \code{train$X}; \code{model} = the fitted model (only 
necessary if you desire to look at this model later, not used for internal 
computations); \code{train_y} = a copy of \code{train$Y}; \code{test_y} = a copy
of \code{test$Y}.
}
\details{
This particular wrapper implements \link[glmnet]{glmnet}. We refer readers to the 
original package's documentation for more
details.
}
\examples{
# load super learner package
library(glmnet)
# simulate data
# make list of training data
train_X <- data.frame(x1 = runif(50), x2 = runif(50))
train_Y <- rbinom(50, 1, plogis(train_X$x1))
train <- list(Y = train_Y, X = train_X)
# make list of test data
test_X <- data.frame(x1 = runif(50), x2 = runif(50))
test_Y <- rbinom(50, 1, plogis(train_X$x1))
test <- list(Y = test_Y, X = test_X)
# fit super learner 
glmnet_wrap <- glmnet_wrapper(train = train, test = test)
}
