% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{findSIMQ}
\alias{findSIMQ}
\title{find quantiles of the simulated data using Rcpp}
\usage{
findSIMQ(SIM,
        X,
        Xbin,
        probs,
        confLevel,
        approx)
}
\arguments{
\item{SIM}{A matrix of simulated data with only Y values collected.}

\item{X}{A numeric vector corresponding to Y}

\item{Xbin}{Binning result from makeCOVbin function}

\item{probs}{A numeric vector of probabilities}

\item{confLevel}{Confidence level of the interval.}

\item{approx}{Arguments to be passed to methods}
}
\value{
quantiles of SIM using xbin
}
\description{
find quantiles of the simulated data using Rcpp
}
\examples{
data(origdata)
data(simdata)
CUT = FindBestCut(origdata$TIME,8)$cutoffs
time_bin = makeCOVbin(origdata$TIME,K=8,cutoffs = CUT)
findSIMQ(simdata,origdata$TIME,Xbin=time_bin,probs=c(0.1,0.5,0.9),
confLevel=0.95,approx=FALSE)
}
