% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsims.R
\name{nsims}
\alias{nsims}
\alias{nsims.nlist}
\alias{nsims.nlists}
\title{Number of MCMC Simulations}
\usage{
nsims(x, ...)

\method{nsims}{nlist}(x, ...)

\method{nsims}{nlists}(x, ...)
}
\arguments{
\item{x}{The object}

\item{...}{Unused.}
}
\value{
A count of the number of simulations.
}
\description{
Gets the number of MCMC simulations (iterations * chains)
}
\section{Methods (by class)}{
\itemize{
\item \code{nlist}: Number of simulations of an nlist object

Always 1L.

\item \code{nlists}: Number of simulations of an nlists object
}}

\examples{
nsims(nlist(x = 1:2))
nsims(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
nsims(split_chains(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7)))))
}
\seealso{
\code{\link[=niters]{niters()}} and \code{\link[=nchains]{nchains()}}
}
