% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMC_configuration.R
\name{configureHMC}
\alias{configureHMC}
\title{Configure HMC}
\usage{
configureHMC(
  model,
  nodes = character(),
  type = "NUTS",
  control = list(),
  print = TRUE,
  ...
)
}
\arguments{
\item{model}{A nimble model, as returned by `nimbleModel`}

\item{nodes}{A character vector of stochastic node names to be sampled. If an empty character vector is provided (the default), then all stochastic non-data nodes will be sampled.  An HMC sampler will be applied to all continuous-valued non-data nodes, and nimble's default sampler will be assigned for all discrete-valued samplin to apply, either "NUTS" or "NUTS_classic".}

\item{type}{A character string specifying the type of HMC sampling to apply, either "NUTS" or "NUTS_classic".  See `help(NUTS)` or `help(NUTS_classic)` for details of each sampler.  The default sampler type is "NUTS".}

\item{control}{Optional named list of control parameters to be passed as the `control` argument to the HMC sampler.  See `help(NUTS)` or `help(NUTS_classic)` for details of the control list elements accepted by each sampler.}

\item{print}{Logical argument specifying whether to print the montiors and samplers.  Default is TRUE.}

\item{...}{Other arguments that will be passed to `configureMCMC`}
}
\value{
An object of class `MCMCconf`.
}
\description{
Create a nimble MCMC configuration object which applies HMC sampling to continuous-valued dimensions
}
\details{
This function can be used like `configureMCMC` in nimble to create an MCMC configuration object.  It will return an MCMC configuration with an HMC sampler assigned to continuous-valued model dimensions, and nimble's default sampler assigned for discrete-valued dimensions (or, only for the nodes specified in the `nodes` argument).  The resulting MCMC configuration object can be used as an argument to `buildMCMC` to generate an executable MCMC algorithm.

Either the `NUTS_classic` or the `NUTS` sampler can be applied.  Both implement variants of No-U-Turn HMC sampling, however the `NUTS` sampler uses more modern adapatation techniques. See `help(NUTS)` or `help(NUTS_classic)` for details.

Use this function if you want to create an MCMC configuration, and then modify it further before building the MCMC algorithm.  `buildHMC` provides a more direct route to a compilable MCMC algorithm with HMC sampling applied to all continuous-valued dimensions.
}
\examples{
code <- nimbleCode({
    b0 ~ dnorm(0, 0.001)
    b1 ~ dnorm(0, 0.001)
    sigma ~ dunif(0, 10000)
    for(i in 1:N) {
        mu[i] <- b0 + b1 * x[i]
        y[i] ~ dnorm(mu[i], sd = sigma)
    }
})

N <- 10
constants <- list(N = N, x = 1:N)
data <- list(y = 1:N)
inits <- list(b0 = 1, b1 = 0.1, sigma = 1)

Rmodel <- nimbleModel(code, constants, data, inits, buildDerivs = TRUE)

## create MCMC configuration object with only an HMC sampler
conf <- configureHMC(Rmodel)

Rmcmc <- buildMCMC(conf)

# Cmodel <- compileNimble(Rmodel)
# Cmcmc <- compileNimble(Rmcmc, project = Rmodel)
# samples <- runMCMC(Cmcmc)
}
\seealso{
\code{\link{addHMC}} \code{\link{buildHMC}} \code{\link{configureMCMC}} \code{\link{addSampler}} \code{\link{sampler_NUTS}} \code{\link{sampler_NUTS_classic}}
}
\author{
Daniel Turek
}
