% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpAaCNOd/file312c3b195778
\name{autoBlock}
\alias{autoBlock}
\title{Automated parameter blocking procedure for efficient MCMC sampling}
\usage{
autoBlock(Rmodel, autoIt = 20000, run = list("all", "default"),
  setSeed = TRUE, verbose = FALSE, makePlots = FALSE, round = TRUE)
}
\arguments{
\item{Rmodel}{A NIMBLE model object, created from \link{nimbleModel}.}

\item{autoIt}{The number of MCMC iterations to run intermediate MCMC algorithms, through the course of the procedure.  Default 20,000.}

\item{run}{List of additional MCMC algorithms to compare against the automated blocking MCMC.  These may be specified as: the character string 'all' to denote blocking all continuous-valued nodes; the character string 'default' to denote NIMBLE's default MCMC configuration; a named list element consisting of a quoted code block, which when executed returns an MCMC configuration object for comparison; a custom-specificed blocking scheme, specified as a named list element which itself is a list of character vectors, where each character vector specifies the nodes in a particular block.  Default is c('all', 'default').}

\item{setSeed}{Logical specificying whether to call set.seed(0) prior to beginning the blocking procedure.  Default TRUE.}

\item{verbose}{Logical specifying whether to output considerable details of the automated block procedure, through the course of execution.  Default FALSE.}

\item{makePlots}{Logical specifying whether to plot the hierarchical clustering dendrograms, through the course of execution.  Default FALSE.}

\item{round}{Logical specifying whether to round the final output results to two decimal places.  Default TRUE.}
}
\value{
Returns a named list containing elements:
\itemize{
\item \code{summary}: A data frame containing a numerical summary of the performance of all MCMC algorithms (including that from automated blocking)
\item \code{autoGroups}: A list specifying the parameter blockings converged on by the automated blocking procedure
\item \code{conf}: A NIMBLE MCMC configuration object corresponding to the results of the automated blocking procedure
}
}
\description{
Runs NIMBLE's automated blocking procedure for a given model object, to dynamically determine a blocking scheme of the continuous-valued model nodes.  This blocking scheme is designed to produce efficient MCMC sampling (defined as number of effective samples generated per second of algorithm runtime).  See Turek, et al (2015) for details of this algorithm.  This also (optionally) compares this blocked MCMC against several static MCMC algorithms, including all univariate sampling, blocking of all continuous-valued nodes, NIMBLE's default MCMC configuration, and custom-specified blockings of parameters.
}
\details{
This method allows for fine-tuned usage of the automated blocking procedure.  However, the main entry point to the automatic blocking procedure is intended to be through either buildMCMC(..., autoBlock = TRUE), or configureMCMC(..., autoBlock = TRUE).
}
\author{
Daniel Turek
}
\references{
Turek, D., de Valpine, P., Paciorek, C., and Anderson-Bergman, C. (2015). Automated Parameter Blocking for Efficient Markov-Chain Monte Carlo Sampling. arXiv: 1503.05621.
}
\seealso{
configureMCMC buildMCMC
}

