% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmpi7IeZS/filee6c4fbdb0a0
\name{simNodesMV}
\alias{calcNodesMV}
\alias{getLogProbNodesMV}
\alias{simNodesMV}
\title{Basic nimbleFunctions for using a NIMBLE model with sets of stored values}
\usage{
simNodesMV(model, mv, nodes)

calcNodesMV(model, mv, nodes)

getLogProbNodesMV(model, mv, nodes)
}
\arguments{
\item{model}{A nimble model.}

\item{mv}{A modelValues object in which multiple sets of model variables and their corresponding logProb values are or will be saved. \code{mv} must include the nodes provided}

\item{nodes}{A set of nodes. If none are provided, default is all \code{model$getNodeNames()}}
}
\value{
from \code{simNodesMV}: NULL.  from \code{calcNodesMV} and \code{getLogProbMV}: a vector of the sum of log probabilities (densities) from any stochastic nodes in \code{nodes}.
}
\description{
simulate, calculate, or get the existing log probabilities for values in a modelValues object using a NIMBLE model
}
\details{
\code{simNodesMV} simulates values in the given nodes and saves them in \code{mv}. \code{calcNodesMV} calculates these nodes for each row of \code{mv} and returns a vector of the total log probabilities (densities) for each row. \code{getLogProbNodesMV} is like \code{calcNodesMV} without actually doing the calculations.

Each of these will expand variables or index blocks and topologically sort them so that each node's parent nodes are processed before itself.

\code{getLogProbMV} should be used carefully.  It is generally for situations where the logProb values are guaranteed to have already been calculated, and all that is needed is to query them.  The risk is that a program may have changed the values in the nodes, in which case \code{getLogProbMV} would collect logProb values that are out of date with the node values.
}
\section{Run time arguments}{

\itemize{
	\item{\code{m} }{

	(\code{simNodesMV} only). Number of simulations requested.}

     \item{\code{saveLP}}{

     (\code{calcNodesMV}only). Whether to save the logProb values in \code{mv}.  Should be given as \code{TRUE} unless there is a good reason not to.}

}
}
\examples{
code <- nimbleCode({
	for(i in 1:5)
	x[i] ~ dnorm(0,1)
})

myModel <- nimbleModel(code)
myMV <- modelValues(myModel)

Rsim <- simNodesMV(myModel, myMV)
Rcalc <- calcNodesMV(myModel, myMV)
Rglp <- getLogProbNodesMV(myModel, myMV)
\dontrun{
  cModel <- compileNimble(myModel)
  Csim <- compileNimble(Rsim, project = myModel)
  Ccalc <- compileNimble(Rcalc, project = myModel)
  Cglp <- compileNimble(Rglp, project = myModel)
  Csim$run(10)
  Ccalc$run(saveLP = TRUE)
  Cglp$run()	#Gives identical answers to Ccalc because logProbs were saved
  Csim$run(10)
  Ccalc$run(saveLP = FALSE)
  Cglp$run()	  #Gives wrong answers because logProbs were not saved
}
}
\author{
Clifford Anderson-Bergman
}

