% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e096b736842
\name{nimbleModel}
\alias{nimbleModel}
\title{Create a NIMBLE model from BUGS code}
\usage{
nimbleModel(code, constants = list(), data = list(), inits = list(),
  dimensions = list(), returnDef = FALSE, where = globalenv(),
  debug = FALSE, check = getNimbleOption("checkModel"), calculate = TRUE,
  name)
}
\arguments{
\item{code}{code for the model in the form returned by \link{nimbleCode} or (equivalently) \code{quote}}

\item{constants}{named list of constants in the model.  Constants cannot be subsequently modified. For compatibility with JAGS and BUGS, one can include data values with constants and \code{nimbleModel} will automatically distinguish them based on what appears on the left-hand side of expressions in \code{code}.}

\item{data}{named list of values for the data nodes.  Data values can be subsequently modified.  Providing this argument also flags nodes as having data for purposes of algorithms that inspect model structure. Values that are NA will not be flagged as data.}

\item{inits}{named list of starting values for model variables. Unlike JAGS, should only be a single list, not a list of lists.}

\item{dimensions}{named list of dimensions for variables.  Only needed for variables used with empty indices in model code that are not provided in constants or data.}

\item{returnDef}{logical indicating whether the model should be returned (FALSE) or just the model definition (TRUE).}

\item{where}{argument passed to \code{setRefClass}, indicating the environment in which the reference class definitions generated for the model and its modelValues should be created.  This is needed for managing package namespace issues during package loading and does not normally need to be provided by a user.}

\item{debug}{logical indicating whether to put the user in a browser for debugging.  Intended for developer use.}

\item{check}{logical indicating whether to check the model object for missing or invalid values.  Default is given by the NIMBLE option 'checkModel', see help on \code{nimbleOptions} for details.}

\item{calculate}{logical indicating whether to run \code{calculate} on the model after building it; this will calculate all deterministic nodes and logProbability values given the current state of all nodes. Default is TRUE. For large models, one might want to disable this, but note that deterministic nodes, including nodes introduced into the model by NIMBLE, may be \code{NA}.}

\item{name}{optional character vector giving a name of the model for internal use.  If omitted, a name will be provided.}
}
\description{
processes BUGS model code and optional constants, data, and initial values. Returns a NIMBLE model or model definition.
}
\details{
See the User Manual or \code{help(modelBaseClass)} for information about manipulating NIMBLE models created by \code{nimbleModel}, including methods that operate on models, such as \code{getDependencies}.

The user may need to provide dimensions for certain variables as in some cases NIMBLE cannot automatically determine the dimensions and sizes of variables. See the User Manual for more information.

As noted above, one may lump together constants and data (as part of the \code{constants} argument (unlike R interfaces to JAGS and BUGS where they are provided as the \code{data} argument). One may not provide lumped constants and data as the \code{data} argument.

For variables that are a mixture of data nodes and non-data nodes, any values passed in via \code{inits} for components of the variable that are data will be ignored. All data values should be passed in through \code{data} (or \code{constants} as just discussed).
}
\examples{
code <- nimbleCode({
    x ~ dnorm(mu, sd = 1)
    mu ~ dnorm(0, sd = prior_sd)
})
constants = list(prior_sd = 1)
data = list(x = 4)
Rmodel <- nimbleModel(code, constants = constants, data = data)
}
\author{
NIMBLE development team
}

