% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_mu.R
\name{extract_mu}
\alias{extract_mu}
\title{extract \eqn{\mu}}
\usage{
extract_mu(
  data,
  pkg = NULL,
  isotope_a = NULL,
  isotope_b = NULL,
  data_format = NULL
)
}
\arguments{
\item{data}{a \code{list} created by the function \code{niw.post()} or \code{siberMVN()}
in the package
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}
or \href{https://cran.r-project.org/package=SIBER}{{SIBER}}, respectfully.}

\item{pkg}{a \code{character} string that is the name of the package that
you're using. Defaults to \code{"nicheROVER"}.
Alternatively the user can supply the argument with \code{"SIBER"}.}

\item{isotope_a}{a \code{character} string to change the column name
of the first isotope used in the analysis. Defaults to \code{"d13c"}.}

\item{isotope_b}{a \code{character} string to change the name of second isotope
used in the analysis. Defaults to \code{"d15n"}.}

\item{data_format}{a \code{character} string that decides whether the returned object is
in long or wide format. Default is \code{"long"}, with the alternative supplied
being \code{"wide"}.}
}
\value{
Returns a \code{tibble} of extracted estimates of \eqn{\mu} created by the
function \code{niw.post()} or \code{siberMVN()} in the packages
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}.
and \href{https://cran.r-project.org/package=SIBER}{{SIBER}}.

The \code{tibble} will contain five columns in the following order, \code{metric},
\code{sample_name}, \code{sample_number}, and the names of the isotope
columns supplied to \code{niw.post()} or  \code{siberMVN()} (e.g., \code{d13c} and  \code{d15n} ).
}
\description{
Extract Bayesian estimates of \eqn{\mu} from data objects created by
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}} or
\href{https://cran.r-project.org/package=SIBER}{{SIBER}}.
}
\examples{
extract_mu(
data = niw_fish_post
)
extract_mu(
data = post_sam_siber,
pkg = "SIBER"
)

}
\seealso{
\code{\link[nicheROVER:niw.post]{nicheROVER::niw.post()}} and \code{\link[SIBER:siberMVN]{SIBER::siberMVN()}}
}
