% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-calculus.R
\name{simpson_num_integr}
\alias{simpson_num_integr}
\title{Simpson's method to integrate a univariate function.}
\usage{
simpson_num_integr(f, a, b, n)
}
\arguments{
\item{f}{function that takes a single argument}

\item{a}{the lower limit of integration}

\item{b}{the upper limit of integration}

\item{n}{integer, number of integration points with a and b}
}
\value{
numeric, the integration value
examples
#expect 1
simpson_num_integr(sin, 0, pi/2, 100)
#max error for simpson_num_integr(sin, 0, pi/2, 100) is 5.312842e-10
1 * (pi/2 - 0)^5/(180 * 100^4)
}
\description{
Simpson's method to integrate a univariate continuous function.
Faster that R's \code{integrate()} and precise enough, but does not do any checks.
The error is at most \verb{M (b-a)^5/(180 n^4)} where \code{M} is the maximum of
the fourth derivative of the integrand in the interval \verb{[a, b]}.
}
\keyword{internal}
