% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp_n.R
\name{ppp_n}
\alias{ppp_n}
\title{Simulate specific number of points from a homogeneous Poisson Point Process over (t_min, t_max]}
\usage{
ppp_n(size, range_t = c(0, 10), rng_stream = NULL)
}
\arguments{
\item{size}{(int) the number of points to be simulated}

\item{range_t}{(vector, double) min and max of the time interval}

\item{rng_stream}{an \code{rstream} object}
}
\value{
a vector of event times of size \code{size}
}
\description{
Simulate specific number of points from a homogeneous Poisson Point Process over (t_min, t_max]
}
\examples{
x <- ppp_n(size = 10, range_t = c(0, 10))
}
