% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_cumulative_intensity_inversion.R
\name{draw_cumulative_intensity_inversion}
\alias{draw_cumulative_intensity_inversion}
\title{Simulate from a non homogeneous Poisson Point Process (NHPPP) from
(t_min, t_max) (inversion method)}
\usage{
draw_cumulative_intensity_inversion(
  Lambda,
  Lambda_inv = NULL,
  range_t = c(0, 10),
  range_L = c(Lambda(range_t[1]), Lambda(range_t[2])),
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{Lambda}{(function, double vector) a continuous increasing R to R map
which is the integrated rate of the NHPPP}

\item{Lambda_inv}{(function, double vector) the inverse of \code{Lambda()}}

\item{range_t}{(vector, double) min and max of the time interval}

\item{range_L}{(vector, double) min and max of the transformed time interval}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object.}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times (t_); if no events realize,
a vector of length 0
}
\description{
Sample NHPPP times using the inversion method,
optionally using an \code{rstream} generator object
}
\examples{
x <- draw_cumulative_intensity_inversion(Lambda = function(t) t + cos(t) - 1)
}
