% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{group_metadata}
\alias{group_metadata}
\alias{group_levels}
\alias{group_levels-method}
\alias{group_names}
\alias{group_names-method}
\alias{group_rows}
\alias{group_rows-method}
\alias{group_length}
\alias{group_length-method}
\alias{group_size}
\alias{group_size-method}
\alias{group_indices}
\alias{group_indices-method}
\alias{is_assigned}
\alias{is_assigned-method}
\alias{any_assigned}
\alias{any_assigned-method}
\alias{all_assigned}
\alias{group_levels,ReferenceGroups-method}
\alias{group_names,ReferenceGroups-method}
\alias{group_indices,ReferenceGroups-method}
\alias{group_rows,ReferenceGroups-method}
\alias{group_length,ReferenceGroups-method}
\alias{group_size,ReferenceGroups-method}
\alias{is_assigned,ReferenceGroups-method}
\alias{any_assigned,ReferenceGroups-method}
\alias{all_assigned,ReferenceGroups-method}
\title{Grouping Metadata}
\usage{
group_levels(object)

group_names(object)

group_rows(object)

group_length(object)

group_size(object)

group_indices(object)

is_assigned(object)

any_assigned(object)

all_assigned(object)

\S4method{group_levels}{ReferenceGroups}(object)

\S4method{group_names}{ReferenceGroups}(object)

\S4method{group_indices}{ReferenceGroups}(object)

\S4method{group_rows}{ReferenceGroups}(object)

\S4method{group_length}{ReferenceGroups}(object)

\S4method{group_size}{ReferenceGroups}(object)

\S4method{is_assigned}{ReferenceGroups}(object)

\S4method{any_assigned}{ReferenceGroups}(object)

\S4method{all_assigned}{ReferenceGroups}(object)
}
\arguments{
\item{object}{A \link[=group]{grouped} \R object.}
}
\description{
Retrieve the (reference) groups to which the observations belong.
}
\section{Functions}{
\itemize{
\item \code{group_levels(ReferenceGroups)}: returns a \code{\link{character}} vector giving the group
names.

\item \code{group_names(ReferenceGroups)}: returns a \code{\link{character}} vector giving the name of
the group that each observation belongs to.

\item \code{group_indices(ReferenceGroups)}: returns an \code{\link{integer}} vector giving the group
that each value belongs to.

\item \code{group_rows(ReferenceGroups)}: returns a \code{list} of \code{\link{integer}} vectors giving the
observation that each group contains.

\item \code{group_length(ReferenceGroups)}: gives the total number of groups.

\item \code{group_size(ReferenceGroups)}: gives the size of each group.

\item \code{is_assigned(ReferenceGroups)}: returns a \code{\link{logical}} vector specifying whether or
not an observation belongs to a group.

\item \code{any_assigned(ReferenceGroups)}: returns an \code{\link{logical}} scalar specifying if any
observation belongs to a group.

\item \code{all_assigned(ReferenceGroups)}: returns an \code{\link{logical}} scalar specifying if all
observations belong to a group.

}}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

## Grouping metadata
group_levels(coda)

group_names(coda)

group_indices(coda)

group_rows(coda)

group_length(coda)

group_size(coda)
}
\seealso{
Other grouping methods: 
\code{\link{group}()},
\code{\link{group_extract}()},
\code{\link{group_split}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
