% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/mutators.R
\docType{class}
\name{ReferenceGroups-class}
\alias{ReferenceGroups-class}
\alias{.ReferenceGroups}
\alias{is_grouped}
\title{Grouped Data}
\usage{
is_grouped(object)
}
\arguments{
\item{object}{A \code{ReferenceGroups} object.}
}
\description{
A virtual S4 class to represent reference groups.
}
\section{Slots}{

\describe{
\item{\code{group_indices}}{An \code{\link{integer}} vector to store the group that each value
belongs to.}

\item{\code{group_levels}}{A \code{\link{character}} vector to store the values of the grouping
variables.}
}}

\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## codaccess
dim(coda) # Get the matrix dimensions
row(coda) # Get the row indexes
col(coda, as.factor = TRUE) # Get the column indexes
nrow(coda) # Get the number of rows
ncol(coda) # Get the number of columns
dimnames(coda) # Get the dimension names
rownames(coda) <- LETTERS[1:25] # Set the row names
rownames(coda) # Get the rownames
colnames(coda) <- letters[21:25] # Set the column names
colnames(coda) # Get the column names
}
\seealso{
Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{GroupedComposition-class}},
\code{\link{GroupedLogRatio-class}},
\code{\link{LogRatio-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OutlierIndex-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
