% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndd.R
\name{ndd}
\alias{ndd}
\alias{dndd}
\alias{pndd}
\alias{qndd}
\alias{rndd}
\title{A new discrete distribution}
\usage{
dndd(x, theta, log = FALSE)

pndd(q, theta, lower.tail = TRUE, log.p = FALSE)

qndd(p, theta, lower.tail = TRUE)

rndd(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dndd} gives the density, \code{pndd} gives the distribution
function, \code{qndd} gives the quantile function and \code{rndd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for a
new discrete distribution parameter.
}
\details{
A new discrete distribution with a parameter \eqn{\theta}, has density given
by
\deqn{f\left( x\right) =\frac{\lambda ^{x}}{1+\theta }
 \left( \theta \left(1-2\lambda \right) +\left( 1-\lambda \right)
 \left( 1+\theta x\right)\right),}
where
\deqn{x=0,1,2,...~,\lambda =\exp \left( -\theta \right) ,~\theta >0.}
}
\examples{
library(new.dist)
dndd(2,theta=2)
pndd(1,theta=2)
qndd(.5,theta=2)
rndd(10,theta=1)
}
\references{
Bakouch, H. S., Jazi, M. A. ve Nadarajah, S., 2014,
\emph{A new discrete distribution, Statistics}, 48 (1), 200-240.
}
