% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeuralGAM.R
\name{neuralGAM}
\alias{neuralGAM}
\title{Fit a neuralGAM model}
\usage{
neuralGAM(
  formula,
  data,
  family = "gaussian",
  num_units = 64,
  learning_rate = 0.001,
  activation = "relu",
  kernel_initializer = "glorot_normal",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  bias_initializer = "zeros",
  activity_regularizer = NULL,
  loss = "mse",
  uncertainty_method = c("none", "epistemic"),
  alpha = 0.05,
  forward_passes = 100,
  dropout_rate = 0.1,
  validation_split = NULL,
  w_train = NULL,
  bf_threshold = 0.001,
  ls_threshold = 0.1,
  max_iter_backfitting = 10,
  max_iter_ls = 10,
  seed = NULL,
  verbose = 1,
  ...
)
}
\arguments{
\item{formula}{Model formula. Smooth terms must be wrapped in \code{s(...)}.
You can specify per-term NN settings, e.g.:
\code{y ~ s(x1, num_units = 1024) + s(x3, num_units = c(1024, 512))}.}

\item{data}{Data frame containing the variables.}

\item{family}{Response distribution: \code{"gaussian"}, \code{"binomial"}, \code{"poisson"}.}

\item{num_units}{Default hidden layer sizes for smooth terms (integer or vector).
\strong{Mandatory} unless every \code{s(...)} specifies its own \code{num_units}.}

\item{learning_rate}{Learning rate for Adam optimizer.}

\item{activation}{Activation function for hidden layers. Either a string understood by
\code{tf$keras$activations$get()} or a function.}

\item{kernel_initializer, bias_initializer}{Initializers for weights and biases.}

\item{kernel_regularizer, bias_regularizer, activity_regularizer}{Optional Keras regularizers.}

\item{loss}{Loss function to use. Can be any Keras built-in (e.g., \code{"mse"}, \code{"mae"},
\code{"huber"}, \code{"logcosh"}) or a custom function, passed directly to \code{keras::compile()}.}

\item{uncertainty_method}{Character string indicating the type of uncertainty to estimate.
One of:
\itemize{
\item \code{"none"} (default): no uncertainty estimation.
\item \code{"epistemic"}: MC Dropout for mean uncertainty (CIs)
}}

\item{alpha}{Significance level for prediction intervals, e.g. \code{0.05} for 95\% coverage.}

\item{forward_passes}{Integer. Number of MC-dropout forward passes used when
\code{uncertainty_method \%in\% c("epistemic","both")}.}

\item{dropout_rate}{Dropout probability in smooth-term NNs (0,1).
\itemize{
\item During training: acts as a regularizer.
\item During prediction (if \code{uncertainty_method} is "epistemic"): enables MC Dropout sampling.
}}

\item{validation_split}{Optional fraction of training data used for validation.}

\item{w_train}{Optional training weights.}

\item{bf_threshold}{Convergence criterion of the backfitting algorithm. Defaults to \code{0.001}}

\item{ls_threshold}{Convergence criterion of the local scoring algorithm. Defaults to \code{0.1}}

\item{max_iter_backfitting}{An integer with the maximum number of iterations
of the backfitting algorithm. Defaults to \code{10}.}

\item{max_iter_ls}{An integer with the maximum number of iterations of the local scoring Algorithm. Defaults to \code{10}.}

\item{seed}{Random seed.}

\item{verbose}{Verbosity: \code{0} silent, \code{1} progress messages.}

\item{...}{Additional arguments passed to \code{keras::optimizer_adam()}.}
}
\value{
An object of class \code{"neuralGAM"}, a list with elements including:
\describe{
\item{muhat}{ Numeric vector of fitted mean predictions (training data).}
\item{partial}{ Data frame of partial contributions \eqn{g_j(x_j)} per smooth term.}
\item{y}{ Observed response values.}
\item{eta}{ Linear predictor \eqn{\eta = \eta_0 + \sum_j g_j(x_j)}.}
\item{lwr,upr}{ Lower/upper confidence interval bounds (response scale)}
\item{x}{ Training covariates (inputs).}
\item{model}{ List of fitted Keras models, one per smooth term (+ \code{"linear"} if present).}
\item{eta0}{ Intercept estimate \eqn{\eta_0}.}
\item{family}{ Model family.}
\item{stats}{ Data frame of training/validation losses per backfitting iteration.}
\item{mse}{ Training mean squared error.}
\item{formula}{ Parsed model formula (via \code{get_formula_elements()}).}
\item{history}{ List of Keras training histories per term.}
\item{globals}{ Global hyperparameter defaults.}
\item{alpha}{ PI significance level (if trained with uncertainty).}
\item{build_pi}{ Logical; whether the model was trained with uancertainty estimation enabled}
\item{uncertainty_method}{ Type of predictive uncertainty used ("none","epistemic").}
\item{var_epistemic}{ Matrix of per-term epistemic variances (if computed).}
}
}
\description{
Fits a Generalized Additive Model where smooth terms are modeled by \code{keras} neural networks.
In addition to point predictions, the model can optionally estimate \strong{uncertainty bands} via Monte Carlo Dropout across forward passes.
}
\examples{
\dontrun{

library(neuralGAM)
dat <- sim_neuralGAM_data()
train <- dat$train
test  <- dat$test

# Per-term architecture and confidence intervals
ngam <- neuralGAM(
  y ~ s(x1, num_units = c(128,64), activation = "tanh") +
       s(x2, num_units = 256),
  data = train,
  uncertainty_method = "epistemic",
  forward_passes = 10,
  alpha = 0.05
)
ngam
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
