% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{networkLite}
\alias{networkLite}
\alias{networkLite.edgelist}
\alias{networkLite.matrix}
\alias{networkLite.numeric}
\alias{networkLite_initialize}
\title{networkLite Constructor Utilities}
\usage{
networkLite(x, ...)

\method{networkLite}{edgelist}(
  x,
  attr = list(vertex.names = seq_len(attributes(x)[["n"]]), na =
    logical(attributes(x)[["n"]])),
  ...,
  atomize = FALSE
)

\method{networkLite}{matrix}(
  x,
  attr = list(vertex.names = seq_len(attributes(x)[["n"]]), na =
    logical(attributes(x)[["n"]])),
  ...,
  atomize = FALSE
)

\method{networkLite}{numeric}(x, directed = FALSE, bipartite = FALSE, ...)

networkLite_initialize(x, directed = FALSE, bipartite = FALSE, ...)
}
\arguments{
\item{x}{Either an \code{edgelist} class network representation, including
network attributes as \code{attr}-style attributes on the
\code{edgelist}, or a number specifying the network size. The
\code{edgelist} may be either a \code{tibble} or a \code{matrix}. If
a \code{tibble} is passed, it should have integer columns named
\code{".tail"} and \code{".head"} for the tails and heads of edges,
and may include edge attributes as additional columns. If a
\code{matrix} is passed, it should have two columns, the first being
the tails of edges and the second being the heads of edges; edge
attributes are not supported for \code{matrix} arguments. Edges
should be sorted, first on tails then on heads. See
\code{\link[network:as.edgelist]{network::as.edgelist}} for information on producing such
\code{edgelist} objects from \code{network} objects. The \code{edgelist}
\emph{must} have the \code{"n"} attribute
indicating the network size, and may include additional named
\code{attr}-style attributes that will be interpreted as network
attributes and copied to the \code{networkLite}. Exceptions to this
are attributes named \code{"class"}, \code{"dim"}, \code{"dimnames"},
\code{"vnames"}, \code{"row.names"}, \code{"names"}, and
\code{"mnext"}; these are not copied from the \code{edgelist} to the
\code{networkLite}.}

\item{...}{additional arguments}

\item{attr}{A named list of vertex attributes, coerced to \code{tibble}.
Each element of \code{attr} should be an atomic vector or list of
length equal to the number of nodes in the network.}

\item{atomize}{Logical; should we call \code{\link{atomize}} on the
\code{networkLite} before returning it? Note that unlike
\code{\link{as.networkLite}}, the default value here is \code{FALSE}.}

\item{directed, bipartite}{Common network attributes that may be set via
arguments to the \code{networkLite.numeric} method.}
}
\value{
A \code{networkLite} object constructed according to the inputs.
}
\description{
Constructor methods for \code{networkLite} objects.
}
\details{
Currently there are several distinct \code{networkLite} constructor
methods available.

The \code{edgelist} method takes an \code{edgelist} class object \code{x}
with network attributes attached in its \code{attributes} list, and a named
list of vertex attributes \code{attr}, and returns a \code{networkLite}
object, which is a named list with fields \code{el}, \code{attr}, and
\code{gal}. The fields \code{el} and \code{attr} are \code{tibble}s
corresponding to the \code{x} and \code{attr} arguments, respectively, and
the field \code{gal} is the list of network attributes (copied from
\code{attributes(x)}, with the exceptions noted above). Missing network
attributes \code{directed} and \code{bipartite} are defaulted to
\code{FALSE}; the network size attribute \code{n} must not be missing.

The \code{numeric} method takes a number \code{x} as well as the network
attributes \code{directed} and \code{bipartite} (defaulting to \code{FALSE}),
and returns an empty \code{networkLite} with these network attributes and
number of nodes \code{x}.

The constructor \code{networkLite_initialize} is also available for creating
an empty \code{networkLite}, and its \code{x} argument should be a number
indicating the size of the \code{networkLite} to create.

Within \code{EpiModel}, the \code{networkLite} data structure is used in the
calls to \code{ergm} and \code{tergm} \code{simulate} and \code{summary}
functions.
}
\examples{
edgelist <- cbind(c(1, 2, 3), c(2, 4, 7))
attr(edgelist, "n") <- 10 # network size
vertex_attributes <- list(a = 1:10, b = runif(10))
nwL <- networkLite(edgelist, vertex_attributes)
nwL

}
