% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netimpact.R
\name{netimpact}
\alias{netimpact}
\title{Determine the importance of individual studies in network
meta-analysis}
\usage{
netimpact(
  x,
  seTE.ignore = 100 * max(x$seTE, na.rm = TRUE),
  event.ignore = 0.01,
  nchar.trts = x$nchar.trts,
  nchar.studlab = x$nchar.studlab,
  verbose = FALSE
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{seTE.ignore}{Assumed (large) standard error in order to
mimicking the removal of individual studies from the network
meta-analysis (ignored for \code{\link{netmetabin}} objects).}

\item{event.ignore}{Assumed event number mimicking the removal of
individual studies from the network meta-analysis (considered for
\code{\link{netmetabin}} objects).}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see Details).}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}

\item{verbose}{A logical indicating whether information on the
estimation progress should be printed.}
}
\value{
An object of class \code{"netimpact"} with corresponding
\code{netgraph} and \code{print} function. The object is a list
containing the following components:
\item{impact.common}{A matrix with contributions of individual
  studies (columns) to comparisons (rows) under the common effects
  model.}
\item{impact.random}{A matrix with contributions of individual
  studies (columns) to comparisons (rows) under the random effects
  model.}
\item{ignored.comparisons}{List with comparisons of ignored study.}
\item{seTE.ignore, event.ignore, x}{As defined above.}
\item{nets}{List of all network meta-analyses (removing a single
  study).}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
This function measures the importance of individual studies in
network meta-analysis by the reduction of the precision if the
study is removed / ignored from the network (Rücker et al., 2020).
}
\examples{
# Only consider first two studies (to reduce runtime of example)
#
studies <- unique(dat.franchini2012$Study)
pw1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = subset(dat.franchini2012, Study \%in\% studies[1:2]),
  studlab = Study)

net1 <- netmeta(pw1)
ni1 <- netimpact(net1, verbose = TRUE)
ni1

netgraph(ni1)

}
\references{
Rücker G, Nikolakopoulou A, Papakonstantinou T, Salanti G, Riley
RD, Schwarzer G (2020):
The statistical importance of a study for a network meta-analysis
estimate.
\emph{BMC Medical Research Methodology},
\bold{20}, 190
}
\seealso{
\code{\link{netmeta}}, \code{\link{netmetabin}},
  \code{\link{netgraph.netimpact}}, \code{\link{print.netimpact}},
  \code{\link[metadat]{dat.franchini2012}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de},
  Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
}
