% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFVariableBase.R
\docType{class}
\name{CFVariableBase}
\alias{CFVariableBase}
\title{Base ancestor of CFVariable and CFArray}
\description{
This class is a basic ancestor to \link{CFVariable} and \link{CFArray}. It
should not be instantiated directly, use the descendant classes instead.

This class provides access to common properties of data variables and the
data they contain.
}
\section{Super class}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{CFVariableBase}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{axes}}{List of instances of classes descending from \link{CFAxis} that
are the axes of the data object. If there are any scalar axes, they are
listed after the axes that associate with the dimensions of the data.
(In other words, axes \verb{1..n} describe the \verb{1..n} data dimensions, while
any axes \verb{n+1..m} are scalar axes.)}

\item{\code{crs}}{The coordinate reference system of this variable, as an
instance of \link{CFGridMapping}. If this field is \code{NULL}, the horizontal
component of the axes are in decimal degrees of longitude and latitude.}

\item{\code{cell_measure}}{The \link{CFCellMeasure} object of this variable, if
defined.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFVariableBase-new}{\code{CFVariableBase$new()}}
\item \href{#method-CFVariableBase-time}{\code{CFVariableBase$time()}}
\item \href{#method-CFVariableBase-summarise}{\code{CFVariableBase$summarise()}}
\item \href{#method-CFVariableBase-profile}{\code{CFVariableBase$profile()}}
\item \href{#method-CFVariableBase-clone}{\code{CFVariableBase$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="add_coordinates"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-add_coordinates'><code>ncdfCF::CFObject$add_coordinates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$new(var, axes, crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{The NC variable that describes this data object.}

\item{\code{axes}}{A \code{list} of \link{CFAxis} descendant instances that describe the
axes of the data object.}

\item{\code{crs}}{The \link{CFGridMapping} instance of this data object, or \code{NULL}
when no grid mapping is available.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-time"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-time}{}}}
\subsection{Method \code{time()}}{
Return the time object from the axis representing time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$time(want = "time")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{want}}{Character string with value "axis" or "time", indicating
what is to be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{want = "axis"} the \link{CFAxisTime} axis; if \code{want = "time"} the
\code{CFTime} instance of the axis, or \code{NULL} if the variable does not have a
"time" axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-summarise"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-summarise}{}}}
\subsection{Method \code{summarise()}}{
Summarise the temporal domain of the data, if present, to
a lower resolution, using a user-supplied aggregation function.

Attributes are copied from the input data variable or data array. Note
that after a summarisation the attributes may no longer be accurate.
This method tries to sanitise attributes (such as removing
\code{scale_factor} and \code{add_offset}, when present, as these will no longer
be appropriate in most cases) but the onus is on the calling code (or
yourself as interactive coder). Attributes like \code{standard_name} and
\code{cell_methods} likely require an update in the output of this method,
but the appropriate new values are not known to this method. Use
\code{CFArray$set_attribute()} on the result of this method to set or update
attributes as appropriate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$summarise(name, fun, period, era = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character vector with a name for each of the results that
\code{fun} returns. So if \code{fun} has 2 return values, this should be a vector
of length 2. Any missing values are assigned a default name of
"result_#" (with '#' being replaced with an ordinal number).}

\item{\code{fun}}{A function or a symbol or character string naming a function
that will be applied to each grouping of data. The function must return
an atomic value (such as \code{sum()} or \code{mean()}), or a vector of atomic
values (such as \code{range()}). Lists and other objects are not allowed and
will throw an error that may be cryptic as there is no way that this
method can assert that \code{fun} behaves properly so an error will pop up
somewhere, most probably in unexpected ways. The function may also be
user-defined so you could write a wrapper around a function like \code{lm()}
to return values like the intercept or any coefficients from the object
returned by calling that function.}

\item{\code{period}}{The period to summarise to. Must be one of either "day",
"dekad", "month", "quarter", "season", "year". A "quarter" is the
standard calendar quarter such as January-March, April-June, etc. A
"season" is a meteorological season, such as December-February,
March-May, etc. (any December data is from the year preceding the
January data). The period must be of lower resolution than the
resolution of the time axis.}

\item{\code{era}}{Optional, integer vector of years to summarise over by the
specified \code{period}. The extreme values of the years will be used. This
can also be a list of multiple such  vectors. The elements in the list,
if used, should have names as these will be used to label the results.}

\item{\code{...}}{Additional parameters passed on to \code{fun}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFData} object, or a list thereof with as many \code{CFData}
objects as \code{fun} returns values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-profile"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-profile}{}}}
\subsection{Method \code{profile()}}{
This method extracts profiles of values from the array of
the variable, with the location along each axis to extract expressed in
coordinate values of each axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$profile(..., .names = NULL, .as_table = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more arguments of the form \code{axis = location}. The
"axis" part should be the name of an axis or its orientation \code{X}, \code{Y},
\code{Z} or \code{T}. The "location" part is a vector of values representing
coordinates along the axis where to profile. A profile will be
generated for each of the elements of the "location" vectors in all
arguments.}

\item{\code{.names}}{A character vector with names for the results. The names
will be used for the \code{CFArray} instances, or as values for the
"location" column of the \code{data.table} if argument \code{.as_table} is
\code{TRUE}. If the vector is shorter than the longest vector of locations
in the \code{...} argument, a name "location_#" will be used, with the #
replaced by the ordinal number of the vector element.}

\item{\code{.as_table}}{Logical to flag if the results should be \code{CFArray}
instances (\code{FALSE}, default) or a single \code{data.table} (\code{TRUE}). If
\code{TRUE}, all \code{...} arguments must have the same number of elements, use
the same axes and the \code{data.table} package must be installed.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The coordinates along each axis to be sampled are expressed in
values of the domain of the axis. Any axes which are not passed as
arguments are extracted in whole to the result. If bounds are set on
the axis, the coordinate whose bounds envelop the requested coordinate
is selected. Otherwise, the coordinate along the axis closest to the
supplied value will be used. If the value for a specified axis falls
outside the valid range of that axis, \code{NULL} is returned.

A typical case is to extract the temporal profile as a 1D array for a
given location. In this case, use arguments for the latitude and
longitude on an X-Y-T data variable: \code{profile(lat = -24, lon = 3)}.
Other profiling options are also possible, such as a 2D zonal
atmospheric profile at a given longitude for an X-Y-Z data variable:
\code{profile(lon = 34)}.

Multiple profiles can be extracted in one call by supplying vectors for
the indicated axes: \code{profile(lat = c(-24, -23, -2), lon = c(5, 5, 6))}.
The vectors need not have the same length, unless \code{.as_table = TRUE}.
With unequal length vectors the result will be a \code{list} of \link{CFArray}
instances with different dimensionality and/or different axes.
\subsection{Auxiliary coordinate variables (CFVariable only)}{

A special case exists for variables where the horizontal dimensions (X
and Y) are not in longitude and latitude coordinates but in some other
coordinate system. In this case the netCDF resource may have so-called
\emph{auxiliary coordinate variables}. If the data variable has such
\emph{auxiliary coordinate variables} then they will be used automatically
if, and only if, the axes are specified as \code{X} and \code{Y}. \strong{Note} that
if you want to profile the data in the original grid units, you should
specify the horizontal axis names.
}
}

\subsection{Returns}{
If \code{.as_table = FALSE}, a list of \link{CFArray} instances, each
having one profile for each of the elements in the "location" vectors
of argument \code{...} and named with the respective \code{.names} value. If
\code{.as_table = TRUE}, a \code{data.table} with a row for each element along
all profiles, with a ".variable" column using the values from the
\code{.names} argument.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
