% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_utility.R
\name{nbc4vaIO}
\alias{nbc4vaIO}
\title{Run nbc4va using file input and output}
\usage{
nbc4vaIO(trainFile, testFile, known = TRUE, csmfaFile = NULL,
  saveFiles = TRUE, outDir = dirname(testFile),
  fileHeader = strsplit(basename(testFile), "\\\\.")[[1]][[1]],
  fileReader = read.csv, fileReaderIn = "file",
  fileReaderArgs = list(as.is = TRUE, stringsAsFactors = FALSE),
  fileWriter = write.csv, fileWriterIn = "x", fileWriterOut = "file",
  fileWriterArgs = list(row.names = FALSE), outExt = "csv")
}
\arguments{
\item{trainFile}{A character value of the path to the data to be used as the \emph{train} argument for \code{\link{nbc}} or a dataframe of the \emph{train} argument.}

\item{testFile}{A character value of the path to the data to be used as the \emph{test} argument for \code{\link{nbc}}  or a dataframe of the \emph{test} argument.}

\item{known}{TRUE to indicate that the \emph{test} causes are available in the 2nd column and FALSE to indicate that they are not known}

\item{csmfaFile}{A character value of the path to the data to be used as the \emph{csmfa.obs} argument for \code{\link{summary.nbc}} or a named vector of the \emph{csmfa.obs} argument.
\itemize{
  \item If (csmfaFile is char): the file must have only 1 column of the causes per case
}}

\item{saveFiles}{Set to TRUE to save the return object as files or FALSE to return the actual object}

\item{outDir}{A character value of the path to the directory to store the output results files.}

\item{fileHeader}{A character value of the file header name to use for the output results files.
\itemize{
  \item The default is to use the name of the \emph{testFile}
}}

\item{fileReader}{A function that is able to read the \emph{trainFile} and the \emph{testFile}.
\itemize{
  \item The default is set to read csv files using \code{\link{read.csv}}
}}

\item{fileReaderIn}{A character value of the \emph{fileReader} argument name that accepts a file path for reading as an input.}

\item{fileReaderArgs}{A list of the \emph{fileReader} arguments to be called with \code{\link{do.call}}.}

\item{fileWriter}{A function that is able to write \code{\link{data.frame}} objects to a file location.
\itemize{
  \item The default is set to write csv files using \code{\link{write.csv}}
}}

\item{fileWriterIn}{A character value of the \emph{fileWriter} argument name that accepts a dataframe for writing.}

\item{fileWriterOut}{A character value of the \emph{fileWriter} argument name that accepts a file path for writing as an output.}

\item{fileWriterArgs}{A list of arguments of the \emph{fileWriter} arguments to be called with \code{\link{do.call}}.}

\item{outExt}{A character value of the extension (without the period) to use for the result files.
\itemize{
  \item The default is set to use the "csv" extension
}
\itemize{
  \item The default is the directory of the \emph{testFile}
}}
}
\value{
out Vector or list of respective paths or data from the naive bayes classifier:
\itemize{
  \item If (\emph{saveFiles} is TRUE) return a named character vector of the following:
  \itemize{
    \item Names: dir, pred, prob, causes, summary
    \item dir (char): the path to the directory of the output files
    \item pred (char): the path to the prediction table file, where the columns of Pred1..PredN are ordered by the prediction probability with Pred1 being the most probable cause
    \item prob (char): the path to the probability table file, where the columns excluding the CaseID are the cause and each cell has a probability value
    \item causes (char): the path to the cause performance metrics table file, where each column is a metric and each row is a cause
    \item metrics (char): the path to the overall performance metrics table file, where each column is a metric
  }
  \item If (\emph{saveFiles} is FALSE) return a list of the following:
  \itemize{
    \item Names: pred, prob, causes, summary
    \item pred (dataframe): the prediction table, where the columns of Pred1..PredN are ordered by the prediction probability with Pred1 being the most probable cause
    \item prob (dataframe): the probability table, where the columns excluding the CaseID are the cause and each cell has a probability value
    \item causes (dataframe): the cause performance metrics table, where each column is a metric and each row is a cause
    \item metrics (dataframe): the summary table, where each column is a performance metric
    \item nbc (object): the returned \code{\link{nbc}} object
    \item nbc_summary (object): the returned \code{\link{summary.nbc}} object
  }
}
}
\description{
Runs \code{\link{nbc}} and uses \code{\link{summary.nbc}} on input data files or dataframes to output
result files or dataframes with data on predictions, probabilities, causes, and performance metrics in an easily accessible way.
}
\details{
See \code{\link{nbc4vaHelpMethods}} for details on the methodology and implementation
of the Naive Bayes Classifier algorithm. This function may also act as a wrapper for the
main nbc4va package functions.
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Split data into train and test sets
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]

# Save train and test data as csv in temp location
trainFile <- tempfile(fileext=".csv")
testFile <- tempfile(fileext=".csv")
write.csv(train, trainFile, row.names=FALSE)
write.csv(test, testFile, row.names=FALSE)

# Use nbc4vaIO via file input and output
# Set "known" to indicate whether test causes are known
outFiles <- nbc4vaIO(trainFile, testFile, known=TRUE)

# Use nbc4vaIO as a wrapper
out <- nbc4vaIO(train, test, known=TRUE, saveFiles=FALSE)

}
\seealso{
Other utility functions: \code{\link{nbc4vaGUI}}
}

