% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regtemplate.R
\name{regtemplate}
\alias{regtemplate}
\alias{regtemplate<-}
\title{Get or set the registration template space in which an object lives}
\usage{
regtemplate(x)

regtemplate(x) <- value
}
\arguments{
\item{x}{The 3D object whose registration space will be set/returned}

\item{value}{The registration template brain (either a character vector
naming the space or a \code{\link{templatebrain}} object)}
}
\value{
Either a \code{templatebrain} object or the newly tagged object
}
\description{
Get or set the registration template space in which an object lives
}
\details{
In order to facilitate transformations between objects in defined
  anatomical spaces these functions allow the registration template for an
  object to be specified. Most of the time you will not need to use these
  functions manually since the appropriate space will be set by the function
  xform_brain and friends.
}
\examples{
\dontrun{
library(nat.flybrains)
kcs3=kcs20[1:3]
regtemplate(kcs3)=FCWB
regtemplate(kcs3)

kcs3m=mirror_brain(kcs3, brain=regtemplate(kcs20))
plot3d(kcs3, col='red')
plot3d(kcs3m, col='green')
}
}
