% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{bridging_graph}
\alias{bridging_graph}
\alias{shortest_bridging_seq}
\title{Make or query connected graph of bridging registrations}
\usage{
bridging_graph(regdirs = getOption("nat.templatebrains.regdirs"),
  reciprocal = NA)

shortest_bridging_seq(sample, reference, checkboth = TRUE,
  imagedata = FALSE, reciprocal = NA, ...)
}
\arguments{
\item{regdirs}{Character vector of directories to search for registrations
(see details)}

\item{reciprocal}{Sets the weight of reciprocal edges in the graph (and
thereby whether inverse registrations will be considered).}

\item{sample}{Source template brain (e.g. IS2) that data is currently in.}

\item{reference}{Target template brain (e.g. IS2) that data should be
transformed into.}

\item{checkboth}{When \code{TRUE} will look for registrations in both
directions. See details.}

\item{imagedata}{Whether \code{x} should be treated as image data (presently
only supported as a file on disk) or 3D object vertices - see details.}

\item{...}{extra arguments to pass to \code{\link[nat]{xform}}.}
}
\description{
These functions are designed for expert use. In general it is
  recommended to use \code{xform_brain}.

  \code{bridging_graph} creates an igraph::graph representing all known
  template brains (vertices) and the bridging registrations connecting them
  (edges).

\code{shortest_bridging_seq} finds the shortest bridging
  sequence on a graph of all available bridging registrations, subject to
  constraints defined by graph connectivity and the \code{reciprocal
  parameter}.
}
\details{
When \code{reciprocal != NA} we create a graph where each forward
  transformation is matched by a corresponding inverse transformation with
  the specified edge weight. The edge weight for forward transforms will
  always be 1.0.

  By default \code{regdirs} is set to getOption('nat.templatebrains.regdirs')
}
\examples{
\dontrun{
plot(bridging_graph(reciprocal=3), vertex.size=25)
# the same including
plot(bridging_graph(), vertex.size=25)
}
\dontrun{
shortest_bridging_seq(FCWB, IS2)
# or
shortest_bridging_seq('FCWB', 'IS2')
}
}
\seealso{
\code{\link{allreg_dataframe}}
}
