% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_aio}
\alias{is_aio}
\alias{is_nano}
\alias{is_ncurl_session}
\title{Validators}
\usage{
is_aio(x)

is_nano(x)

is_ncurl_session(x)
}
\arguments{
\item{x}{an object.}
}
\value{
Logical value TRUE or FALSE.
}
\description{
Validator functions for object types created by \{nanonext\}.
}
\details{
Is the object an Aio (inheriting from class \sQuote{sendAio} or
\sQuote{recvAio}).

Is the object an object inheriting from class \sQuote{nano} i.e. a
nanoSocket, nanoContext, nanoStream, nanoListener, nanoDialer, nanoMonitor or
nano Object.

Is the object an ncurlSession (object of class \sQuote{ncurlSession}).

Is the object a Condition Variable (object of class
\sQuote{conditionVariable}).
}
\examples{
nc <- call_aio(ncurl_aio("https://postman-echo.com/get", timeout = 1000L))
is_aio(nc)

s <- socket()
is_nano(s)
n <- nano()
is_nano(n)
close(s)
n$close()

s <- ncurl_session("https://postman-echo.com/get")
is_ncurl_session(s)
if (is_ncurl_session(s)) close(s)

}
