library(nanonext)

n <- nano("pair", listen = "inproc://nanonext", autostart = FALSE)
n1 <- nano("pair", dial = "inproc://nanonext", autostart = FALSE)

invisible(inherits(n, "nanoObject") || stop())
invisible(inherits(n$socket, "nanoSocket") || stop())
invisible(inherits(n$socket, "nano") || stop())
invisible(is.integer(attr(n$socket, "id")) || stop())
invisible(n$socket$state == "opened" || stop())
invisible(n$socket$protocol == "pair" || stop())
invisible(suppressMessages(n$send("not ready")) > 0L || stop())
invisible(suppressMessages(n$recv()) > 0L || stop())
invisible(n$socket_setopt("size", "recv-size-max", 8192) == 0 || stop())
invisible(n$socket_setopt("int", "recv-buffer", 8) == 0 || stop())
invisible(n$socket_setopt("string", "socket-name", "nano") == 0 || stop())

invisible(inherits(n$listener[[1]], "nanoListener") || stop())
invisible(n$listener[[1]]$url == "inproc://nanonext" || stop())
invisible(n$listener[[1]]$state == "not started" || stop())
invisible(n$listener_setopt("size", "recv-size-max", 1024) == 0 || stop())
invisible(n$listener_start() == 0L || stop())
invisible(n$listener[[1]]$state == "started" || stop())

invisible(inherits(n1$dialer[[1]], "nanoDialer") || stop())
invisible(n1$dialer[[1]]$url == "inproc://nanonext" || stop())
invisible(n1$dialer[[1]]$state == "not started" || stop())
invisible(n1$dialer_setopt("ms", "reconnect-time-min", 1000) == 0 || stop())
invisible(n1$dialer_setopt("size", "recv-size-max", 8192) == 0 || stop())
invisible(n1$dialer_start() == 0L || stop())
invisible(n1$dialer[[1]]$state == "started" || stop())

invisible(n$send(data.frame(), block = FALSE, echo = FALSE))
invisible(n1$recv(block = FALSE))
n1$send("test", mode = "raw", block = FALSE, echo = FALSE)
invisible(n$recv("character", block = FALSE))
saio <- n$send_aio(data.frame(), timeout = 500)
invisible(!is.null(saio[["aio"]]) || stop())
invisible(!is.null(saio$result) || stop())
raio <- n1$recv_aio(timeout = 500)
invisible(!is.null(raio[["aio"]]) || stop())
invisible(!is.null(raio$data) || stop())
invisible(!is.null(raio$raw) || stop())
saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500)
invisible(is.logical(unresolved(saio)) || stop())
msg <- n1$recv_aio(timeout = 500)
invisible(is.null(stop_aio(msg)) || stop())

xc <- n$dial(url = "inproc://two", autostart = TRUE)
invisible(is.integer(xc) || stop())
invisible(inherits(n$dialer[[1L]], "nanoDialer") || stop())
xc <- n$listen(url = "inproc://three")
invisible(is.integer(xc) || stop())
invisible(inherits(n$listener[[2L]], "nanoListener") || stop())

invisible(close(n$listener[[1]]) == 0L || stop())
invisible(suppressMessages(close(n$listener[[1]])) > 0L || stop())
invisible(close(n1$dialer[[1]]) == 0L || stop())
invisible(suppressMessages(close(n1$dialer[[1]])) > 0L || stop())
invisible(n$close() == 0L || stop())
invisible(n1$close() == 0L || stop())
invisible(suppressMessages(n1$close()) > 0L || stop())
invisible(n$socket[["state"]] == "closed" || stop())
invisible(n1$socket[state] == "closed" || stop())

n <- nano("req", listen = "inproc://testing")
n1 <- nano("rep", dial = "inproc://testing")
invisible(n$socket_setopt("ms", "req:resend-time", 1000) == 0 || stop())
ctx <- context(n$socket)
ctx1 <- context(n1$socket)
invisible(inherits(ctx, "nanoContext") || stop())
invisible(inherits(ctx, "nano") || stop())
invisible(is.integer(ctx$id) || stop())
invisible(ctx$state == "opened" || stop())
invisible(ctx$protocol == "req" || stop())
invisible(setopt(ctx, "ms", "send-timeout", 1000) == 0L || stop())
send_ctx(ctx, data.frame(), timeout = 500, echo = FALSE)
invisible(recv_ctx(ctx1, timeout = 500))
send_ctx(ctx, "context test", mode ="raw", timeout = 500, echo = FALSE)
invisible(recv_ctx(ctx1, mode = "character", timeout = 100))
invisible(close(ctx) == 0L || stop())
invisible(suppressMessages(close(ctx)) > 0L || stop())
invisible(ctx$state == "closed" || stop())
ctx2 <- context(n1)
invisible(close(ctx2) == 0L || stop())

sub <- nano("sub", dial = "inproc://nanonext", autostart = FALSE)
invisible(subscribe(sub$socket, "test") == 0L || stop())
invisible(unsubscribe(sub$socket, "test") == 0L || stop())
invisible(subscribe(sub$socket, NULL) == 0L || stop())
invisible(unsubscribe(sub$socket, NULL) == 0L || stop())
invisible(sub$close() == 0L || stop())

sock <- socket(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2")
sock2 <- socket(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1")
invisible(!is.null(sock$dialer) && !is.null(sock$listener) || stop())
invisible(close(sock) == 0L || stop())
invisible(close(sock2) == 0L || stop())

invisible(is.character(ver <- nng_version()) && length(ver) == 2L || stop())
invisible(is.character(nng_error(0L)) || stop())
invisible(is_nul_byte(as.raw(0L)) && !is_nul_byte(NULL) || stop())
invisible(!is_error_value(1L) || stop())

