% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{call_aio}
\alias{call_aio}
\title{Call the Result of an Asynchronous AIO Operation}
\usage{
call_aio(aio)
}
\arguments{
\item{aio}{An Aio (object of class 'sendAio' or 'recvAio').}
}
\value{
The passed Aio object (invisibly).
}
\description{
Retrieve the result of an asynchronous AIO operation. Will wait for the AIO
    operation to complete (blocking) if this is still in progress.
}
\details{
To access the values directly, use for example on a sendAio 'x':
    \code{call_aio(x)$result}.

    For a 'sendAio', the send result will be attached to the Aio in \code{$result}.
    This will be zero on success.

    For a 'recvAio', the received raw vector will be attached in \code{$raw}
    (unless 'keep.raw' was set to FALSE when receiving), and the converted R
    object in \code{$data}.

    For a 'recvAio', in case of an error in unserialisation or data conversion,
    the received raw vector will always be saved in \code{$raw} to allow the
    data to be recovered.

    Once the result is retrieved, the Aio is deallocated and only the result
    is stored in the Aio object.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
res
call_aio(res)
res
res$result

res <- recv_aio(s2, timeout = 100)
res
call_aio(res)$data
res

close(s1)
close(s2)

}
