% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-recode.R
\name{where}
\alias{where}
\alias{.where}
\title{Split a call into two components with a useful verb name}
\usage{
.where(...)
}
\arguments{
\item{...}{case_when style formula}
}
\value{
a list of "condition" and "suffix" arguments
}
\description{
This function is used inside \code{recode_shadow} to help evaluate the formula
call effectively. \code{.where} is a special function designed for use in
\code{recode_shadow}, and you shouldn't use it outside of it
}
\examples{

\dontrun{
df <- tibble::tribble(
~wind, ~temp,
-99,    45,
68,    NA,
72,    25
)

dfs <- bind_shadow(df)

recode_shadow(dfs,
              temp = .where(wind == -99 ~ "bananas"))

}

}
