% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-miss-point.R
\name{geom_miss_point}
\alias{geom_miss_point}
\title{geom_miss_point}
\usage{
geom_miss_point(
  mapping = NULL,
  data = NULL,
  prop_below = 0.1,
  jitter = 0.05,
  stat = "miss_point",
  position = "identity",
  colour = ..missing..,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. If specified and \code{inherit.aes = TRUE}
(the default), is combined with the default mapping at the top level of the
plot. You only need to supply mapping if there isn't a mapping defined for
the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{prop_below}{the degree to shift the values. The default is 0.1}

\item{jitter}{the amount of jitter to add. The default is 0.05}

\item{stat}{The statistical transformation to use on the data for this layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{colour}{the colour chosen for the aesthetic}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. borders.}

\item{...}{other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. There
are three types of arguments you can use here:
\itemize{
\item{Aesthetics: to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3.}}
\item{Other arguments to the layer, for example you override the default
\code{stat} associated with the layer.}
\item{Other arguments passed on to the stat.}
}}
}
\description{
\code{geom_miss_point} provides a way to transform and plot missing
values in ggplot2. To do so it uses methods from ggobi to display missing
data points 10\\% below the minimum value, so that the values can be seen on
the same axis.
}
\details{
Plot Missing Data Points
}
\note{
Warning message if na.rm = T is supplied.
}
\examples{

library(ggplot2)

# using regular geom_point()
ggplot(airquality,
       aes(x = Ozone,
           y = Solar.R)) +
geom_point()

# using  geom_miss_point()
ggplot(airquality,
       aes(x = Ozone,
           y = Solar.R)) +
 geom_miss_point()

 # using facets

ggplot(airquality,
       aes(x = Ozone,
           y = Solar.R)) +
 geom_miss_point() +
 facet_wrap(~Month)

}
\seealso{
[gg_miss_case()][gg_miss_case_cumsum()][gg_miss_fct()][gg_miss_span()][gg_miss_var()][gg_miss_var_cumsum()][gg_miss_which()]
}
