% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-n-prop-miss.R
\name{add_prop_miss}
\alias{add_prop_miss}
\title{Add column containing proportion of missing data values}
\usage{
add_prop_miss(data, ..., label = "prop_miss")
}
\arguments{
\item{data}{a dataframe}

\item{...}{Variable names to use instead of the whole dataset. By default this
looks at the whole dataset. Otherwise, this is one or more unquoted
expressions separated by commas. These also respect the dplyr verbs
\code{starts_with}, \code{contains}, \code{ends_with}, etc. By default will add "_all" to
the label if left blank, otherwise will add "_vars" to distinguish that it
has not been used on all of the variables.}

\item{label}{character string of what you need to name variable}
}
\value{
a dataframe
}
\description{
It can be useful when doing data analysis to add the proportion of missing
data values into your dataframe. \code{add_prop_miss} adds a column named
"prop_miss", which contains the proportion of missing values in that row.
You can specify the variables that you would like to show the missingness
for.
}
\examples{

airquality \%>\% add_prop_miss()

airquality \%>\% add_prop_miss(Solar.R)

airquality \%>\% add_prop_miss(Solar.R, Ozone)

airquality \%>\% add_prop_miss(Solar.R, Ozone, label = "testing")

# this can be applied to model the proportion of missing data
# as in Tierney et al bmjopen.bmj.com/content/5/6/e007450.full
library(rpart)
library(rpart.plot)

airquality \%>\%
add_prop_miss() \%>\%
rpart(prop_miss_all ~ ., data = .) \%>\%
prp(type = 4,
    extra = 101,
    prefix = "prop_miss = ")
}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}} \code{\link[=cast_shadow]{cast_shadow()}}
}
