% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-x.R
\name{gg_miss_var}
\alias{gg_miss_var}
\title{Plot the number of missings for each variable}
\usage{
gg_miss_var(x, show_pct = FALSE)
}
\arguments{
\item{x}{a dataframe}

\item{show_pct}{logical shows the number of missings (default), but if set to
TRUE, it will display the proportion of missings.}
}
\value{
a ggplot object depicting the number of missings in a given column
}
\description{
This is a visual analogue to \code{miss_var_summary}. It draws a ggplot of the
number of missings in each variable, ordered to show which variables have
the most missing data. A default minimal theme is used, which can be
customised as normal for ggplot.
}
\examples{

gg_miss_var(airquality)
library(ggplot2)
gg_miss_var(airquality) + labs(y = "Look at all the missing ones")

}
