% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{CorrectForBleaching}
\alias{CorrectForBleaching}
\alias{CorrectForBleachingFolder}
\title{Detrend an image series}
\usage{
CorrectForBleaching(arr, tau, n.ch = 1)

CorrectForBleachingFolder(folder.path = ".", tau = NA, mst = NULL,
  ext = "tif", na = "error", mcc = parallel::detectCores(), seed = NULL)
}
\arguments{
\item{arr}{An array, can be 3- or 4-dimensional. The first two slots give the
x- and y-cordinates of pixels respectively. If the array is 3-dimensional,
the third slot gives the index of the frame. If it is 4-dimensional, the
third slot indexes the channel and the fourth indexes the frame in the
stack.. To perform this on a file that has not yet been read in, set this
argument to the path to that file (a string).}

\item{tau}{The time constant for the exponential filtering. If this is set to
\code{'auto'}, then the value of \code{tau} is calculated automatically via
\code{\link[=BestTau]{BestTau()}}.}

\item{n.ch}{The number of channels in the image (default 1).}

\item{folder.path}{The path (relative or absolute) to the folder you wish to
process.}

\item{mst}{Do you want to apply an intensity threshold prior to correcting
for bleaching (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your
thresholding \emph{method} here.}

\item{ext}{The file extension of the images in the folder that you wish to
process. You must wish to process all files with this extension; if there
are files that you don't want to process, take them out of the folder. The
default is for tiff files. Do not use regular expression in this argument.}

\item{na}{How do you want to treat \code{NA} values? R can only write integer
values (and hence not \code{NA}s) to tiff pixels. \code{na = 'saturate'} sets them to
saturated value. \code{na = 'zero'} sets them to zero, while \code{na = 'error'} will
give an error if the image contains \code{NA}s. Note that if you threshold, you
are almost certain to get \code{NA}s.}

\item{mcc}{The number of cores to use for the parallel processing.}

\item{seed}{A seed for the random number generation for \link{BestTau}. Don't use
\link{set.seed}, it won't work.}
}
\value{
\code{CorrectForBleaching} returns the detrended image series.
}
\description{
\code{CorrectForBleaching} applies detrending to an image time series using the
method described in Nolan et al. 2017. \code{CorrectForBleachingFolder} performs
this correction on all images in a folder, writing the corrected images to
disk.
}
\details{
If you wish to apply thresholding and bleaching correction, aplpluy the
thresholding first. \code{CorrectforBleachingFolder} takes care of this for you.
}
\examples{
library(magrittr)
img <- ReadImageData(system.file("extdata", "50.tif", package = "nandb"))
autotau <- CorrectForBleaching(img, "auto")
setwd(tempdir())
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
set.seed(33)
CorrectForBleachingFolder(tau = 1000, mst = "Huang", mcc = 2, na = "s")
list.files()
file.remove(list.files())

}
\references{
Stroud, P. D.: A recursive exponential filter for time-sensitive
data, Los Alamos national Laboratory, LAUR-99-5573,
\url{public.lanl.gov/stroud/ExpFilter/ExpFilter995573.pdf}, 1999.
}
