% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genAssign.R
\name{genAssign}
\alias{genAssign}
\alias{genAssign.default}
\alias{genAssign.numPed}
\title{Generation assignment}
\usage{
genAssign(pedigree, ...)

\method{genAssign}{default}(pedigree, ...)

\method{genAssign}{numPed}(pedigree, ...)
}
\arguments{
\item{pedigree}{A pedigree where the columns are ordered ID, Dam, Sire}

\item{\dots}{Arguments to be passed to methods}
}
\value{
A vector of values is returned.  This vector is in the same order as
the ID column of the pedigree.
}
\description{
Given a pedigree, the function assigns the generation number to which each
individual belongs.
}
\details{
0 is the base population.

Migrants, or any individuals where both parents are unknown, are assigned to
generation zero.  If parents of an individual are from two different
generations (e.g., dam = 0 and sire = 1), the individual is assigned to the
generation following the greater of the two parents (e.g., 2 in this
example).
}
\author{
\email{matthewwolak@gmail.com}
}
