% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDsim.R, R/makeSdsim.R
\name{makeDsim}
\alias{makeDsim}
\alias{makeSdsim}
\alias{makeSdsim}
\alias{makeDsim}
\title{Create the dominance genetic relationship matrix through an iterative
(simulation) process}
\usage{
makeDsim(pedigree, N, parallel = FALSE, ncores = getOption("mc.cores", 2L),
  invertD = TRUE, calcSE = FALSE, returnA = FALSE)

makeSdsim(pedigree, heterogametic, N, DosageComp = c(NULL, "ngdc", "hori",
  "hedo", "hoha", "hopi"), parallel = FALSE, ncores = getOption("mc.cores",
  2L), invertSd = TRUE, calcSE = FALSE, returnS = FALSE)
}
\arguments{
\item{pedigree}{A pedigree with columns organized: ID, Dam, Sire. For use
with \code{makeSdsim}, a fourth column indicates the sex of each individual
in the pedigree.}

\item{N}{The number of times to iteratively trace alleles through the
pedigree}

\item{parallel}{A logical indicating whether or not to use parallel
processing. Note, this may only be available for Mac and Linux operating
systems.}

\item{ncores}{The number of cpus to use when constructing the dominance
relatedness matrix. Default is all available.}

\item{invertD, invertSd}{A logical indicating whether or not to invert the D
or Sd matrix}

\item{calcSE}{A logical indicating whether or not the standard errors for
each coefficient of fraternity should be calculated}

\item{returnA, returnS}{Logical, indicating if the numerator relationship
matrix (A or S) should be stored and returned.}

\item{heterogametic}{Character indicating the label corresponding to the
heterogametic sex used in the "Sex" column of the pedigree}

\item{DosageComp}{A character indicating which model of dosage compensation.
If \code{NULL} then the \dQuote{ngdc} model is assumed.}
}
\value{
a \code{list}:
  \describe{
    \item{A,S }{the A or S matrix in sparse matrix form}
    \item{D,Sd }{the approximate D or Sd matrix in sparse matrix form}
    \item{logDetD,logDetSd }{the log determinant of the approximate D or
      approximate Sd matrix}
   \item{Dinv,Sdinv }{the inverse of the approximate D or approximate Sd
     matrix in sparse matrix form}
   \item{listDinv,listSdinv }{the three column form of the non-zero elements 
     for the inverse of the approximate D matrix or the inverse of the
     approximate Sd matrix}
   \item{Dsim,Sdsim }{the simulated D or Sd matrix in sparse matrix form}
   \item{logDetDsim,logDetSdsim }{the log determinant of the simulated D or
     simulated Sd matrix}
   \item{Dsiminv,Sdsiminv }{the inverse of the simulated D or simulated Sd
     matrix in sparse matrix form}
   \item{listDsim,listSdsim }{the three column form of the non-zero and
     non-self elements for the simulated D or simulated Sd matrix}
   \item{listDsiminv,listSdsiminv }{the three column form of the non-zero
     elements for the inverse of the simulated D or the inverse of the 
     simulated Sd matrix}
  }
}
\description{
Alleles are explicitly traced through a pedigree to obtain coefficients of
fraternity between pairs of individuals (the probability of sharing both
alleles identical by descent) - for either autosomes or sex chromosomes.
This is accomplished in an iterative process to account for the various
routes by which an allele will progress through a pedigree due to Mendelian
sampling at either autosomes or sex chromosomes. The autosomal case is an
implementation of the simulation approach of Ovaskainen et al. (2008).
}
\details{
Missing parents (e.g., base population) should be denoted by either 'NA',
'0', or '*'.

\code{parallel} = TRUE should only be used on Linux or Mac operating systems
(i.e., not Windows).

Ovaskainen et al. (2008) indicated that the method of calculating the D
matrix (see \code{\link{makeD}}) is only an approximation.  They proposed a
simulation method that is implemented here.  This should be more
appropriate, especially when inbreeding occurs in the pedigree.

The objects \code{listDsim} and \code{listSdsim} will list both the
approximate values (returned from \code{\link{makeD}} or
\code{\link{makeSd}}) as well as the simulated values.  If \code{calcSE} is
TRUE, these values will be listed in \code{listDsim} or \code{listSdsim}.
}
\note{
This simulation can take a long time for large pedigrees (a few
  thousand and higher) and large values of \code{N} (one thousand and 
  higher). If unsure, it is advisable to start with a lower \code{N} and 
  gradually increase to obtain a sense of the time required to execute a 
  desired \code{N}.
}
\examples{

  simD <- makeDsim(Mrode9, N = 1000, parallel = FALSE,
		invertD = TRUE, calcSE = TRUE)$listDsim

  simSd <- makeSdsim(FG90, heterogametic = "0", N = 1000, parallel = FALSE,
		invertSd = TRUE, calcSE = TRUE)$listSdsim
}
\references{
Ovaskainen, O., Cano, J.M., & Merila, J. 2008. A Bayesian
framework for comparative quantitative genetics. Proceedings of the Royal
Society B 275, 669-678.
}
\seealso{
\code{\link{makeD}}, \code{\link{makeSd}}
}
\author{
\email{matthewwolak@gmail.com}
}
