% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_factor.R
\name{unknown_to_na}
\alias{unknown_to_na}
\alias{unknown_to_na.naaccr_record}
\alias{unknown_to_na.factor}
\title{Replace labels for unknown with NA}
\usage{
unknown_to_na(x, ...)

\method{unknown_to_na}{naaccr_record}(x, ...)

\method{unknown_to_na}{factor}(x, field, ...)
}
\arguments{
\item{x}{Either a factor created with \code{\link{naaccr_factor}}, or a
\code{\link{naaccr_record}} object.}

\item{...}{Further arguments passed to or from other methods.}

\item{field}{String giving the XML name of the NAACCR field to code.}
}
\value{
If \code{x} was a \code{factor}, then the result is a vector with the
  values of \code{x}, except all levels which effectively mean "unknown" are
  replaced with \code{NA}.
  The returned factor won't have those in its levels, either.

  If \code{x} is a \code{naaccr_record} object, then the result is the
  \code{naaccr_record} created by applying this function to all columns of
  \code{x}.
}
\description{
Replace labels for unknown with NA
}
\examples{
  r <- naaccr_record(
    sex = c("1", "2", "9"),
    kras = c("8", "9", "3"),
    keep_unknown = TRUE
  )
  r
  unknown_to_na(r[["sex"]], field = "sex")
  unknown_to_na(r)
}
