% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_snow_agg}
\alias{mc_calc_snow_agg}
\title{Summary of TRUE/FALSE snow sensor}
\usage{
mc_calc_snow_agg(
  data,
  snow_sensor = "snow",
  localities = NULL,
  period = 3,
  use_utc = FALSE
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package} with TRUE/FALSE snow sensor see \code{\link[=mc_calc_snow]{mc_calc_snow()}}}

\item{snow_sensor}{name of snow sensor containing TRUE/FALS snow detection, suitable for virtual sensors created by function \code{mc_calc_snow}; (default "snow")}

\item{localities}{optional subset of localities where to run the function (list of locality_ids); if NULL then return all localities (default NULL)}

\item{period}{number of days defining the continual snow cover period of interest (default 3 days)}

\item{use_utc}{if set FALSE then time is shifted based on offset provided in locality metadata \code{tz_offset}, see e.g. \code{\link[=mc_prep_solar_tz]{mc_prep_solar_tz()}}, \code{\link[=mc_prep_meta_locality]{mc_prep_meta_locality()}}; (default FALSE)}
}
\value{
Returns data.frame with columns:
\itemize{
\item locality - locality id
\item snow_days - number of days with snow cover
\item first_day - first day with snow
\item last_day - last day with snow
\item first_day_period - first day of period with continual snow cover based on \code{period} parameter
\item last_day_period - last day of period with continual snow cover based on \code{period} parameter
}
}
\description{
This function works with the virtual snow sensor of TRUE/FALSE
which is the output of \code{\link[=mc_calc_snow]{mc_calc_snow()}}. So, before calling
\code{mc_calc_snow_agg} you need to calculate or import \code{mc_read_}
TRUE/FALSE snow sensor.
\code{mc_calc_snow_agg} returns the summary table of snow sensor
(e.g number of days with snow cover, first and last date of continual
snow cover longer than input period).
The snow summary is returned for whole date range provided. And is returned as
new data.frame in contrast with other mc_calc functions returning virtual sensors.
}
\details{
Primary designed for virtual snow sensor calculated by \code{\link[=mc_calc_snow]{mc_calc_snow()}},
but accepts any sensor with TRUE/FLAST snow event detection. If \code{snow_sensor}
on the locality is missing, then locality is skipped.
}
\examples{
data <- mc_calc_snow(mc_data_example_agg, "TMS_T2", output_sensor="TMS_T2_snow",
                     localities = c("A2E32", "A6W79"))
mc_calc_snow_agg(data, "TMS_T2_snow")
}
