/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Blocks;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.AtomicDouble;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Postprocessor;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Preprocessor;
import ru.itmo.ctlab.virgo.sgmwcs.solver.RLTSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Solver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Worker;

public class ComponentSolver
implements Solver {
    private final int threshold;
    private TimeLimit tl;
    private AtomicDouble lb;
    private boolean isSolvedToOptimality;
    private int logLevel;
    private int threads;
    private boolean cplexOff;
    private final double eps;
    private final boolean minimize;
    private int preprocessLevel;
    private Graph g;
    private Signals s;
    private final int[] preprocessedSize = new int[]{0, 0};
    long startTime;
    BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    ExecutorService executor;

    public int preprocessedNodes() {
        return this.preprocessedSize[0];
    }

    public int preprocessedEdges() {
        return this.preprocessedSize[1];
    }

    public ComponentSolver(int threshold, double eps) {
        this.threshold = threshold;
        this.minimize = eps > 0.0;
        this.eps = eps;
        this.lb = new AtomicDouble(Double.NEGATIVE_INFINITY);
        this.tl = new TimeLimit(Double.POSITIVE_INFINITY);
        this.threads = 1;
    }

    @Override
    public List<Unit> solve(Graph graph, Signals signals) throws SolverException {
        this.g = graph;
        this.s = signals;
        Graph g = new Graph();
        Signals s = new Signals();
        int vertexBefore = graph.vertexSet().size();
        int edgesBefore = graph.edgeSet().size();
        Utils.copy(graph, signals, g, s);
        HashSet<Unit> units = new HashSet<Unit>(g.vertexSet());
        units.addAll(g.edgeSet());
        new Preprocessor(g, s, this.threads, this.logLevel).preprocess(this.preprocessLevel);
        this.preprocessedSize[0] = g.vertexSet().size();
        this.preprocessedSize[1] = g.edgeSet().size();
        if (this.logLevel > 0) {
            System.out.print("Preprocessing deleted " + (vertexBefore - g.vertexSet().size()) + " nodes ");
            System.out.println("and " + (edgesBefore - g.edgeSet().size()) + " edges.");
        }
        this.isSolvedToOptimality = false;
        if (g.vertexSet().size() == 0) {
            return null;
        }
        return this.afterPreprocessing(g, new Signals(s, units));
    }

    private List<Unit> afterPreprocessing(Graph graph, Signals signals) throws SolverException {
        this.startTime = System.currentTimeMillis();
        PriorityQueue<Set<Node>> components = this.getComponents(graph);
        ArrayList<Worker> memorized = new ArrayList<Worker>();
        this.executor = new ThreadPoolExecutor(this.threads, this.threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, this.queue);
        while (!components.isEmpty()) {
            Set<Node> component = components.poll();
            Graph subgraph = graph.subgraph(component);
            Node root = null;
            double timeRemains = this.tl.getRemainingTime() - (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
            if (component.size() >= this.threshold && timeRemains > 0.0 && (root = this.getRoot(subgraph, new Blocks(subgraph))) != null) {
                this.addComponents(subgraph, root, components);
            }
            this.addWorker(subgraph, signals, root, memorized);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getResult(memorized, graph, signals);
    }

    private List<Unit> getResult(List<Worker> memorized, Graph graph, Signals signals) throws SolverException {
        List<Unit> best = null;
        double bestScore = -1.7976931348623157E308;
        for (Worker worker : memorized) {
            List<Unit> solution = worker.getResult();
            if (solution == null) {
                throw new SolverException("Worker " + memorized.indexOf(worker) + "failed");
            }
            if (!(bestScore < Utils.sum(solution, signals))) continue;
            best = solution;
            bestScore = Utils.sum(solution, signals);
            this.isSolvedToOptimality = worker.isSolvedToOptimality();
        }
        List<Unit> result = Unit.extractAbsorbed(best);
        graph.vertexSet().forEach(Unit::clear);
        graph.edgeSet().forEach(Unit::clear);
        if (this.minimize && bestScore > 0.0) {
            System.out.println("RUNNING MINIMIZATION");
            return new Postprocessor(this.g, this.s, result, this.logLevel).minimize(this.eps, this.tl);
        }
        return result;
    }

    private Node getRoot(Graph graph, Blocks blocks) {
        HashMap<Node, Integer> maximum = new HashMap<Node, Integer>();
        if (blocks.cutpoints().isEmpty()) {
            return null;
        }
        Node v = blocks.cutpoints().iterator().next();
        this.dfs(v, null, blocks, maximum, graph.vertexSet().size());
        if (maximum.isEmpty()) {
            return null;
        }
        Node best = (Node)maximum.keySet().iterator().next();
        for (Node u : maximum.keySet()) {
            if ((Integer)maximum.get(u) >= (Integer)maximum.get(best)) continue;
            best = u;
        }
        return best;
    }

    private int dfs(Node v, Node p, Blocks blocks, Map<Node, Integer> max, int n) {
        int res = 0;
        for (Set<Node> c : blocks.incidentBlocks(v)) {
            if (c.contains(p)) continue;
            int sum = c.size() - 1;
            for (Node cp : blocks.cutpointsOf(c)) {
                if (cp == v) continue;
                sum += this.dfs(cp, v, blocks, max, n);
            }
            if (!max.containsKey(v) || max.get(v) < sum) {
                max.put(v, sum);
            }
            res += sum;
        }
        int rest = n - res - 1;
        if (!max.containsKey(v) || max.get(v) < rest) {
            max.put(v, rest);
        }
        return res;
    }

    @Override
    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    private void addComponents(Graph graph, Node root, PriorityQueue<Set<Node>> components) {
        graph = graph.subgraph(graph.vertexSet());
        graph.removeVertex(root);
        components.addAll(graph.connectedSets());
    }

    private PriorityQueue<Set<Node>> getComponents(Graph graph) {
        PriorityQueue<Set<Node>> result = new PriorityQueue<Set<Node>>(new SetComparator());
        result.addAll(graph.connectedSets());
        return result;
    }

    @Override
    public TimeLimit getTimeLimit() {
        return this.tl;
    }

    @Override
    public void setTimeLimit(TimeLimit tl) {
        this.tl = tl;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setThreadsNum(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.threads = n;
    }

    @Override
    public void setLB(AtomicDouble lb) {
        this.lb = lb;
    }

    @Override
    public AtomicDouble getLB() {
        return this.lb;
    }

    public void addWorker(Graph subgraph, Signals signals, Node root, List<Worker> memorized) {
        Set<Unit> subset = subgraph.units();
        Signals subSignals = new Signals(signals, subset);
        RLTSolver solver = null;
        if (!this.cplexOff) {
            solver = new RLTSolver(this.minimize ? 0.0 : 1.0E-6);
            solver.setLB(this.lb);
            solver.setTimeLimit(this.tl);
            solver.setLogLevel(this.logLevel);
        }
        Worker worker = new Worker(subgraph, root, subSignals, solver, this.startTime);
        this.executor.execute(worker);
        memorized.add(worker);
    }

    public void setPreprocessingLevel(int preprocessLevel) {
        this.preprocessLevel = preprocessLevel;
    }

    public void setCplexOff(boolean cplexOff) {
        this.cplexOff = cplexOff;
    }

    public static class SetComparator
    implements Comparator<Set<Node>> {
        @Override
        public int compare(Set<Node> o1, Set<Node> o2) {
            return -Integer.compare(o1.size(), o2.size());
        }
    }
}

