/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public class Utils {
    public static double sum(Collection<? extends Unit> units, Signals signals) {
        if (units == null) {
            return 0.0;
        }
        double result = 0.0;
        HashSet<? extends Unit> us = new HashSet<Unit>();
        us.addAll(units);
        block0: for (int i = 0; i < signals.size(); ++i) {
            List<Unit> set = signals.set(i);
            for (Unit unit : set) {
                if (!us.contains(unit)) continue;
                result += signals.weight(i);
                continue block0;
            }
        }
        return result;
    }

    public static void copy(Graph inGr, Signals inS, Graph outGr, Signals outS) {
        HashMap oldToNew = new HashMap();
        inGr.vertexSet().forEach(v -> {
            Node nv = new Node((Node)v);
            outGr.addVertex(nv);
            oldToNew.put(v, nv);
        });
        inGr.edgeSet().forEach(e -> {
            Node nv = (Node)oldToNew.get(inGr.getEdgeSource((Edge)e));
            Node nu = (Node)oldToNew.get(inGr.getEdgeTarget((Edge)e));
            Edge ne = new Edge((Edge)e);
            outGr.addEdge(nv, nu, ne);
            oldToNew.put(e, ne);
        });
        for (int i = 0; i < inS.size(); ++i) {
            int sz = i;
            List<Unit> oldUnits = inS.set(i);
            outS.addSignal(inS.weight(i));
            oldUnits.forEach(u -> {
                Unit nu = (Unit)oldToNew.get(u);
                outS.add(nu, sz);
            });
        }
    }

    public static <T> Set<Set<T>> subsets(Set<T> set) {
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        if (set.isEmpty()) {
            result.add(new HashSet());
            return result;
        }
        ArrayList<T> units = new ArrayList<T>(set);
        Object head = units.get(0);
        units.remove(0);
        Set<Set<T>> ss = Utils.subsets(new HashSet<T>(units));
        for (Set<T> s : ss) {
            HashSet<T> ns = new HashSet<T>(s);
            result.add(s);
            ns.add(head);
            result.add(ns);
        }
        return result;
    }

    public static Set<Node> nodes(Collection<? extends Unit> units) {
        return units.stream().filter(e -> e instanceof Node).map(e -> (Node)e).collect(Collectors.toSet());
    }

    public static Set<Edge> edges(Collection<? extends Unit> units) {
        return units.stream().filter(e -> e instanceof Edge).map(e -> (Edge)e).collect(Collectors.toSet());
    }

    public static class CurrentThreadExecutorService
    extends AbstractExecutorService {
        private volatile boolean shutdown;

        @Override
        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = Collections.emptyList();
            if (list == null) {
                CurrentThreadExecutorService.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.shutdown;
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
            if (timeUnit == null) {
                CurrentThreadExecutorService.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                CurrentThreadExecutorService.$$$reportNull$$$0(2);
            }
            if (this.shutdown) {
                throw new IllegalStateException();
            }
            command.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ru/itmo/ctlab/virgo/sgmwcs/solver/Utils$CurrentThreadExecutorService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ru/itmo/ctlab/virgo/sgmwcs/solver/Utils$CurrentThreadExecutorService";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "awaitTermination";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

