% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVS.R
\name{predict.MVS}
\alias{predict.MVS}
\title{Make predictions from an "MVS" object.}
\usage{
\method{predict}{MVS}(object, newx, predtype = "response", cvlambda = "lambda.min", ...)
}
\arguments{
\item{object}{An object of class "MVS".}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a matrix.}

\item{predtype}{The type of prediction returned by the meta-learner. Supported are types "response", "class" and "link".}

\item{cvlambda}{Values of the penalty parameters at which predictions are to be made. Defaults to the values giving minimum cross-validation error.}

\item{...}{Further arguments to be passed to \code{\link[glmnet]{predict.cv.glmnet}}.}
}
\value{
A matrix of predictions.
}
\description{
Make predictions from a "MVS" object.
}
\examples{
\donttest{ 
set.seed(012)
n <- 1000
X <- matrix(rnorm(8500), nrow=n, ncol=85)
top_level <- c(rep(1,45), rep(2,20), rep(3,20))
bottom_level <- c(rep(1:3, each=15), rep(4:5, each=10), rep(6:9, each=5))
views <- cbind(bottom_level, top_level)
beta <- c(rep(10, 55), rep(0, 30)) * ((rbinom(85, 1, 0.5)*2)-1)
eta <- X \%*\% beta
p <- 1 /(1 + exp(-eta))
y <- rbinom(n, 1, p)

fit <- MVS(x=X, y=y, views=views, type="StaPLR", levels=3, alphas=c(0,1,1), nnc=c(0,1,1))
coefficients <- coef(fit)

new_X <- matrix(rnorm(2*85), nrow=2)
predict(fit, new_X)}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
