% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{MVNMIX}
\alias{MVNMIX}
\title{Random Generation for the Normal Mixture Distribution}
\usage{
MVNMIX(n, p, lambda, mu2, rho1 = 0, rho2 = 0)
}
\arguments{
\item{n}{number of rows (observations).}

\item{p}{total number of columns (variables).}

\item{lambda}{weight parameter to allocate the proportions of the mixture, \eqn{0<\lambda<1}.}

\item{mu2}{is \eqn{bl} of \eqn{N(bl, \sum_2)}.}

\item{rho1}{parameter in \eqn{\sum_1}.}

\item{rho2}{parameter in \eqn{\sum_2}.}
}
\value{
Returns univariate (\eqn{p=1}) or multivariate (\eqn{p>1}) random sample matrix.
}
\description{
Generate univariate or multivariate random sample for the normal mixture distribution with density
\eqn{\lambda N(0,\sum_1)+(1-\lambda)N(bl, \sum_2)}, where \eqn{l} is the column vector with all elements being 1,
\eqn{\sum_i=(1-\rho_i)I+\rho_ill^T} for \eqn{i=1,2}. \eqn{\rho} has to satisfy \eqn{\rho > -1/(p-1)} in order to make the
covariance matrix meaningful.
}
\examples{
set.seed(12345)

## Generate 5X2 random sample matrix from MVNMIX(0.5,4,0,0) ##
MVNMIX(n=5, p=2, lambda=0.5, mu2=4, rho1=0, rho2=0)


## Power calculation against bivariate (p=2) MVNMIX(0.5,4,0,0) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

# Zhou-Shao's test #
power.mvnTest(a=0.05, n=50, p=2, B=100, FUN=MVNMIX, lambda=0.5, mu2=4, rho1=0, rho2=0)

}
\references{
Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.
}
