\name{make.del}
\alias{make.del}
\title{ Make the upper triangular matrix del from a parameter vector }
\description{
  \code{make.del} takes a parameter vector of length \eqn{k*(k+1)/2} and
  returns the upper triangular \eqn{k \times k} matrix \eqn{\Delta}.
  \code{make.del} is a private function intended for use inside \code{mlest}.
}
\usage{
make.del(pars)
}
\arguments{
  \item{pars}{ A length \eqn{k*(k+1)/2} numerical vector giving the
      elements of \eqn{\Delta}. }
}
\details{
  The first \eqn{k} elements of \code{pars} are the log of the diagonal
  elements of \eqn{\Delta}. The next \eqn{k*(k-1)/2} elements are the
  elements above the main diagonal of \eqn{\Delta}, ordered  by column
  (left to right), and then by row within column (top to bottom).  That
  is to say, if \eqn{\Delta_{ij}} is the element in the \eqn{i}th row
  and \eqn{j}th column of \eqn{\Delta}, then the order of the parameters
  is \eqn{\Delta_{11}, \Delta_{22}, \ldots, \Delta_{kk}, \Delta_{12},
      \Delta_{13}, \Delta_{23}, \Delta_{14}, \ldots,\Delta_{(k-1)k}}.  }

\value{
  An upper triangular \eqn{k \times k} matrix.
}
\references{
    Pinheiro, J. C., and Bates, D. M.  (2000) \emph{Mixed-effects models in
     S and S-PLUS}.  New York: Springer.}

\seealso{ \code{\link{mlest}} }

\keyword{algebra}
