% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_forecast-class.R
\name{summary.mvgam_forecast}
\alias{summary.mvgam_forecast}
\title{Posterior summary of hindcast and forecast objects}
\usage{
\method{summary}{mvgam_forecast}(object, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{an object of class \code{mvgam_forecast} obtained using either the
\code{hindcast()} or \code{function()} function. This object will contain
draws from the posterior distribution of hindcasts and forecasts.}

\item{probs}{The upper and lower percentiles to be computed by the
\code{quantile} function, in addition to the median}

\item{...}{ignored}
}
\value{
A long-format \code{tibble} / \code{data.frame} reporting the posterior median,
upper and lower percentiles of the predictions for each series at each of
the timepoints that were originally supplied in \code{data} and, optionally,
in \code{newdata}.
}
\description{
This function takes an \code{mvgam_forecast} object and
calculates a posterior summary of the hindcast and forecast distributions
of each series, along with any true values that were included in \code{data}
and \code{newdata} if \code{type = 'response'} was used in the call to
\code{hindcast()} or \code{function()}
}
\seealso{
\code{\link{forecast.mvgam}}, \code{\link{plot.mvgam_forecast}}
}
\author{
Nicholas J Clark
}
