% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvNormQMC.R
\name{mvtNormQuasiMonteCarlo}
\alias{mvtNormQuasiMonteCarlo}
\title{Multivariate Normal Distribution Function}
\usage{
mvtNormQuasiMonteCarlo(p, upperBound, cov, genVec)
}
\arguments{
\item{p}{The number of samples used in the quasi-Monte carlo. Must be a prime number.}

\item{upperBound}{Vector of probabilities, i.e., the upper bound of the integral.}

\item{cov}{The covariance matrix of the multivariate normal distribution. Must be semi-positive definite.
WARING: for performance in high-dimensions, no check is performed so it is the user responsability to ensure
that this property is verified.}

\item{genVec}{Generating vector for the quasi-Monte Carlo procedure. Can be computed using \code{generatingVector}.}
}
\value{
An estimate of the distribution function along with empirical Monte Carlo error.
}
\description{
Estimate the multivariate distribution function with quasi-Monte Carlo method.
}
\details{
The function uses quasi-Monte Carlo methods based on randomly shifted
lattice rules to estimate the distribution function a multivariate normal distribution
as described in Genz, A. and Bretz, F.(2009).
}
\examples{

#Define locations
loc <- expand.grid(1:4, 1:4)
ref <- sample.int(16, 1)

#Compute variogram matrix
variogramMatrix <- ((sqrt((outer(loc[,1],loc[,1],"-"))^2 +
(outer(loc[,2],loc[,2],"-"))^2)) / 2)^(1.5)

#Define an upper boud
upperBound <- variogramMatrix[-ref,ref]

#Compute covariance matrix
cov <-  (variogramMatrix[-ref,ref]\%*\%t(matrix(1, (nrow(loc) - 1), 1)) +
t(variogramMatrix[ref,-ref]\%*\%t(matrix(1, (nrow(loc) - 1), 1))) -
variogramMatrix[-ref,-ref])

#Compute generating vector
p <- 499
vec <- genVecQMC(p, (nrow(loc) - 1))

#Compute log-likelihood function
mvtNormQuasiMonteCarlo(p, upperBound, cov, vec)
}
\references{
Genz, A. and Bretz, F. (2009). Computations of Multivariate Normal and t Probabilities, volume 105. Springer, Dordrecht.

            Genz, A. (2013). QSILATMVNV \url{http://www.math.wsu.edu/faculty/genz/software/software.html}
}

