% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propriety.R
\name{make_roth_ineqmat}
\alias{make_roth_ineqmat}
\alias{make_rosy_ineqmat}
\title{Define hyperplanes for Rothenberg arrangements}
\usage{
make_roth_ineqmat(card)

make_rosy_ineqmat(card)
}
\arguments{
\item{card}{The cardinality of the scale(s) to be studied}
}
\value{
A matrix with \code{card+1} columns and k rows, where k is the number of hyperplanes
in the arrangement.
}
\description{
Although the Rothenberg propriety of a single scale can be computed directly with \code{\link[=isproper]{isproper()}},
propriety is a scalar feature (like modal "color") which is defined by a scale's position in
the geometry of continuous pc-set space. That is, propriety, contradictions, and ambiguities are
all determined by a scale's relationship to a hyperplane arrangement, but the arrangements which
define these properties are different from the ones of Modal Color Theory. \code{make_roth_ineqmat()}
creates the \code{ineqmats} needed to study those arrangements, similar to what \code{\link[=makeineqmat]{makeineqmat()}} does
for MCT arrangements. \code{make_rosy_ineqmat()} creates the combination of Rothenberg and MCT arrangements.
(The name puns on the "Roth" of Rothenberg meaning "red," lending a reddish
or rosy tint to the "colors" of the MCT arrangement.)
}
\details{
Each row of a Rothenberg \code{ineqmat} represents a hyperplane, just like the rows produced by
\code{\link[=makeineqmat]{makeineqmat()}}. The rows are normalized so that their first non-zero entry is either \code{1} or \code{-1},
and their orientations are assigned so that a strictly proper set will return only \code{-1}s for its
sign vector relative to the Rothenberg arrangement. A \code{0} in a Rothenberg sign vector represents
an ambiguity. Note that the Rothenberg arrangements are never "central," which means that the
hyperplanes do \emph{not} all intersect at the perfectly even scale. (It is clear that they must not,
because perfectly even scales have no ambiguities.) These arrangements also grow in complexity
much faster than the MCT arrangements do: for tetrachords, MCT arrangements have 8 hyperplanes while
Rothenberg arrangements have 22. For heptachords, those numbers increase to 42 and 259, respectively.
Thus, this function runs slowly when called on cardinalities of only modest size (e.g. 12-24).
}
\examples{
c_major <- c(0, 2, 4, 5, 7, 9, 11)
hepta_roth_ineqmat <- make_roth_ineqmat(7)
isproper(c_major)
cmaj_roth_sv <- signvector(c_major, ineqmat=hepta_roth_ineqmat)
table(cmaj_roth_sv)
hepta_roth_ineqmat[which(cmaj_roth_sv==0),] 
# This reveals that c_major has one ambiguity, which results from
# the interval from 4 to 7 being exactly half an octave.

}
