% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{partition_group}
\alias{partition_group}
\alias{partition_group_}
\title{Partition data so that each group is wholly on a node}
\usage{
partition_group(.self, ...)

partition_group_(.self, ..., .dots)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
Partitions data across the cluster such that each group is wholly
contained on a single node.
}
\details{
This should not typically be called explicitly; group_by achieves the same
thing. Generally speaking it would be fairly pointless to group things and
then not have each group fully accessible, but theoretically is possible to
so (use \code{group_by (..., auto_partition=FALSE}).
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(c("A", "B", "C", "D"), each=25))
dat \%>\% partition_group (G)
dat \%>\% shutdown()
}
}
\seealso{
Other cluster functions: \code{\link{partition_even}},
  \code{\link{shutdown}}
}

