% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ab_max.R
\name{Ab_max}
\alias{Ab_max}
\title{Automatic Construction of Ab-Representation for Common Inequality Constraints}
\usage{
Ab_max(which_max, options, exclude = c(), exclude_fixed = FALSE,
  drop_fixed = TRUE)
}
\arguments{
\item{which_max}{vector of indices refering to probabilities that are
assumed to be larger than the remaining probabilities
(e.g., \code{which_max=c(1,2)} means that \code{p1>p3, p1>p4,..., p2>p3, ...}).
Note that the indices refer to \emph{all} probabilities/categories (including
one fixed probability within each multinomial distribution).}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{exclude}{vector of indices refering to probabilities that are
excluded from the construction of the order constraints (including
the fixed probabilities).}

\item{exclude_fixed}{whether to exclude the fixed probabilities (i.e., the
last probability within each multinomial) from the construction of the
order constraints. For example, if \code{options=c(2,2,3)} then the
probabilities/columns 2, 4, and 7 are dropped (which is equivalent to
\code{exclude=c(2,4,7)}). This option is usually appropriate for binomial
probabilities (i.e., if \code{options = c(2,2,2,...)}), e.g., when the
interest is in the probability of correct responding across different item types.}

\item{drop_fixed}{whether to drop columns of \code{A} containing the
fixed probabilities (i.e., the last probability within each multinomial).
\emph{after} construction of the inequalities.}
}
\value{
a list with the matrix \code{A} and the vectors \code{b} and \code{options}
}
\description{
Constructs the matrix \code{A} and vector \code{b} of the Ab-representation
\code{A*x < b} for common inequality constraints such as "the probability j is
larger than all others (\code{Ab_max})" or "the probabilities are ordered
(\code{Ab_monotonicity})").
}
\examples{
# Example 1: Multinomial with 5 categories
# Hypothesis: p1 is larger than p2,p3,p4,p5
Ab_max(which_max = 1, options = 5)

# Example 2: Four binomial probabilities
# Hypothesis: p1 is larger than p2,p3,p4
Ab_max(which_max = 1, options = c(2,2,2,2), exclude_fixed = TRUE)
}
