% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data.R
\name{multi}
\alias{multi}
\title{Multinomial outcome data}
\usage{
multi(..., inclusive = FALSE, type = c("ordered", "competing"))
}
\arguments{
\item{...}{Two or more numeric columns (or vectors) of category counts.
Argument names (optional) will be used to label the categories.}

\item{inclusive}{Logical, are ordered category counts inclusive (\code{TRUE}) or
exclusive (\code{FALSE})? Default \code{FALSE}. Only used when \code{ordered = TRUE}. See details.}

\item{type}{String, indicating whether categories are \code{"ordered"} or
\code{"competing"}. Currently only ordered categorical outcomes are supported by
the modelling functions in this package.}
}
\value{
A matrix of (exclusive) category counts
}
\description{
This function aids the specification of multinomial outcome data when setting
up a network with \code{\link[=set_agd_arm]{set_agd_arm()}} or \code{\link[=set_ipd]{set_ipd()}}. It takes a set of columns
(or, more generally, numeric vectors of the same length) of outcome counts in
each category, and binds these together to produce a matrix.
}
\details{
When specifying ordered categorical counts, these can either be
given as \emph{exclusive} counts (\code{inclusive = FALSE}, the default) where
individuals are only counted in the highest category they achieve, or
\emph{inclusive} counts (\code{inclusive = TRUE}) where individuals are counted in
every category up to and including the highest category achieved.
(Competing outcomes, by nature, are always specified as exclusive counts.)

\code{NA} values can be used to indicate categories/cutpoints that were not
measured.
}
\examples{
# These two data sets specify the same ordered categorical data for outcomes
# r0 < r1 < r2, but the first uses the "inclusive" format and the second the
# "exclusive" format.
df_inclusive <- tibble::tribble(~r0, ~r1, ~r2,
                                1, 1, 1,
                                5, 4, 1,
                                5, 2, 2,
                                10, 5, 0,
                                5, 5, 0,
                                7, NA, 6,   # Achieved r2 or not (no r1)
                                10, 4, NA)  # Achieved r1 or not (no r2)

df_exclusive <- tibble::tribble(~r0, ~r1, ~r2,
                                0, 0, 1,
                                1, 3, 1,
                                3, 0, 2,
                                5, 5, 0,
                                0, 5, 0,
                                1, NA, 6,   # Achieved r2 or not (no r1)
                                6, 4, NA)   # Achieved r1 or not (no r2)

(r_inclusive <- with(df_inclusive, multi(r0, r1, r2, inclusive = TRUE)))
(r_exclusive <- with(df_exclusive, multi(r0, r1, r2, inclusive = FALSE)))

# Counts are always stored in exclusive format
stopifnot(isTRUE(all.equal(r_inclusive, r_exclusive)))


## HTA Plaque Psoriasis
library(dplyr)

# Ordered outcomes here are given as "exclusive" counts
head(hta_psoriasis)

# Calculate lowest category count (failure to achieve PASI 50)
pso_dat <- hta_psoriasis \%>\%
  mutate(`PASI<50` = sample_size - rowSums(cbind(PASI50, PASI75, PASI90), na.rm = TRUE))

# Set up network
pso_net <- set_agd_arm(pso_dat,
                       study = paste(studyc, year),
                       trt = trtc,
                       r = multi(`PASI<50`, PASI50, PASI75, PASI90,
                                 inclusive = FALSE,
                                 type = "ordered"))

pso_net

}
