% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.compilr}
\alias{summary.compilr}
\title{Create a Summary of a \code{compilr} object}
\usage{
\method{summary}{compilr}(
  object,
  class = c("composition", "logratio"),
  level = c("between", "within", "total"),
  weight = c("equal", "proportional"),
  digits = 3,
  ...
)
}
\arguments{
\item{object}{An object of class \code{compilr}.}

\item{class}{Optional. Can be \code{"composition"} and/or \code{"logratio"} to
specify the geometry of the composition.}

\item{level}{Optional. Can be \code{"between"}, \code{"within"}, and/or \code{"total"}
indicating the level of the geometry.}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals).
Default is \code{equal}.}

\item{digits}{A integer value used for number formatting. Default is \code{3}.}

\item{...}{generic argument, not in use.}
}
\description{
Create a Summary of a \code{compilr} object
}
\examples{
cilr <- compilr(data = mcompd, sbp = sbp, 
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), 
                idvar = "ID")
summary(cilr)
}
