% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosa.R
\name{rosa}
\alias{rosa}
\title{Response Oriented Sequential Alternation - ROSA}
\usage{
rosa(
  formula,
  ncomp,
  Y.add,
  common.comp = 1,
  data,
  subset,
  na.action,
  scale = FALSE,
  weights = NULL,
  validation = c("none", "CV", "LOO"),
  internal.validation = "LOO",
  fixed.block = NULL,
  design.block = NULL,
  canonical = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictor block names separated by + signs.}

\item{ncomp}{The maximum number of ROSA components.}

\item{Y.add}{Optional response(s) available in the data set.}

\item{common.comp}{Automatically create all combinations of common components up to length \code{common.comp} (default = 1).}

\item{data}{The data set to analyse.}

\item{subset}{Expression for subsetting the data before modelling.}

\item{na.action}{How to handle NAs (no action implemented).}

\item{scale}{Optionally scale predictor variables by their individual standard deviations.}

\item{weights}{Optional object weights.}

\item{validation}{Optional cross-validation strategy "CV" or "LOO".}

\item{internal.validation}{Optional cross-validation for block selection process, "LOO", "CV3", "CV5", "CV10" (CV-number of segments), or vector of integers.}

\item{fixed.block}{integer vector with block numbers for each component (0 = not fixed) or list of length <= ncomp (element length 0 = not fixed).}

\item{design.block}{integer vector containing block numbers of design blocks}

\item{canonical}{logical indicating if canonical correlation should be use when calculating loading weights (default), enabling B/W maximization, common components, etc. Alternatively (FALSE) a PLS2 strategy, e.g. for spectra response, is used.}

\item{...}{Additional arguments for \code{cvseg} or \code{rosa.fit}}
}
\value{
An object of classes \code{rosa} and \code{mvr} having several associated printing (\code{\link{rosa_results}}) and plotting methods (\code{\link{rosa_plots}}).
}
\description{
Formula based interface to the ROSA algorithm following the style of the \code{pls} package.
}
\details{
ROSA is an opportunistic method sequentially selecting components from whichever block explains
the response most effectively. It can be formulated as a PLS model on concatenated input block with block
selection per component. This implementation adds several options that are not described in the literature.
Most importantly, it opens for internal validation in the block selection process, making this more
robust. In addition it handles design blocks explicitly, enables classification and secondary responses (CPLS),
and definition of common components.
}
\examples{
data(potato)
mod <- rosa(Sensory[,1] ~ ., data = potato, ncomp = 10, validation = "CV", segments = 5)
summary(mod)
}
\references{
Liland, K.H., Næs, T., and Indahl, U.G. (2016). ROSA - a fast extension of partial least squares regression for multiblock data analysis. Journal of Chemometrics, 30, 651–662, doi:10.1002/cem.2824.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{rosa_results}} and \code{\link{rosa_plots}}, respectively.
}
