% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtscr_score.R
\name{mtscr_score}
\alias{mtscr_score}
\title{Score creativity with MTS}
\usage{
mtscr_score(
  df,
  id_column,
  item_column = NULL,
  score_column,
  top = 1,
  format = c("minimal", "full"),
  ties_method = c("random", "average"),
  normalise = TRUE,
  self_ranking = NULL
)
}
\arguments{
\item{df}{Data frame in long format.}

\item{id_column}{Name of the column containing participants' id.}

\item{item_column}{Optional, name of the column containing distinct trials
(e.g. names of items in AUT).}

\item{score_column}{Name of the column containing divergent thinking scores
(e.g. semantic distance).}

\item{top}{Integer or vector of integers (see examples), number of top answers
to prepare indicators for. Default is 1, i.e. only the top answer.}

\item{format}{Character, controls the format of the output data frame. Accepts:
\describe{
\item{\code{"minimal"}}{default, returns only the creativity scores and id columns.}
\item{\code{"full"}}{returns the original data frame with creativity scores columns added.}
}}

\item{ties_method}{Character string specifying how ties are treated when
ordering. Can be \code{"average"} (better for continuous scores like semantic
distance) or \code{"random"} (default, better for ratings). See \code{\link[=rank]{rank()}} for details.}

\item{normalise}{Logical, should the creativity score be normalised? Default is \code{TRUE} and
it's recommended to leave it as such.}

\item{self_ranking}{Name of the column containing answers' self-ranking.
Provide if model should be based on top answers self-chosen by the participant.
Every item should have its own ranks. The top answers should have a value of 1,
and the other answers should have a value of 0. In that case, the \code{top} argument
doesn't change anything and should be left as \code{top = 1}. \code{ties_method} is not used if \code{self_ranking}
was provided. See \link{mtscr_self_rank} for example.}
}
\value{
A tibble with creativity scores. If \code{format = "full"}, the original data frame is
returned with scores columns added. Otherwise, only the scores and id columns are returned.
number of creativity scores columns (e.g. \code{creativity_score_top2}) depends on the \code{top} argument.
}
\description{
Score creativity with MTS
}
\examples{
data("mtscr_creativity", package = "mtscr")
mtscr_score(mtscr_creativity, id, item, SemDis_MEAN, top = 1:2)

# add scores to the original data frame
mtscr_score(mtscr_creativity, id, item, SemDis_MEAN, format = "full")

# use self-chosen best answers
data("mtscr_self_rank", package = "mtscr")
mtscr_score(mtscr_self_rank, subject, task, avr, self_ranking = top_two)
}
\seealso{
\code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}} for converting the output to wide format by yourself.
}
