% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{compute.costs.proximity.graph}
\alias{compute.costs.proximity.graph}
\title{Computes the edge costs sum of a proximity graph}
\usage{
compute.costs.proximity.graph(graph.edges, distance.matrix)
}
\arguments{
\item{graph.edges}{A object of class "matrix" with two columns (\emph{object_i}, \emph{object_j}) representing the objects (nodes) of a proximity graph.}

\item{distance.matrix}{A distance matrix between each pair of object i,j in the proximity graph.}
}
\value{
\item{total.costs.graph}{A numeric value representing the edge costs (distance) overall sum of a proximity graph.}
}
\description{
This function computes the edge costs (distances) overall sum of a proximity graph.
}
\examples{

set.seed(1987)

##Generates a data matrix of dimension 50X13
n=50; m=13
x <- matrix(runif(n*m, min = -5, max = 10), nrow=n, ncol=m)

##Computes a distance matrix of x.

library("stats")
d <- base::as.matrix(stats::dist(x, method="euclidean"))

##Generates complete graph (CG)

cg <- generate.complete.graph(1:nrow(x),d)

##Generates a proximity graph (MST)
mstree <- generate.mst(cg)

##Calculate the edge cost sum of proximity graph (MST)
mstree.cost=as.numeric(compute.costs.proximity.graph(as.matrix(mstree$edges.mst.graph[,1:2]), d))
mstree.cost

##Generates a proximity graph (kNN)
knneig <- generate.knn(cg)

##Calculate the edge cost sum of proximity graph (kNN)
knneig.cost=as.numeric(compute.costs.proximity.graph(as.matrix(knneig$edges.knn.graph[,1:2]), d))
knneig.cost
}
\keyword{internal}
